/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang;

import com.google.firebase.rules.v1.SourcePosition;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

public class SourcePositionFactory {
    private final boolean includeSourceOffset;
    private final int sourceFileIndex;

    public SourcePositionFactory(boolean includeSourceOffset, int sourceFileIndex) {
        this.includeSourceOffset = includeSourceOffset;
        this.sourceFileIndex = sourceFileIndex;
    }

    public SourcePosition.Builder fromToken(Token token) {
        SourcePosition.Builder builder = SourcePosition.newBuilder().setFileIndex(this.sourceFileIndex).setLine(token.getLine()).setColumn(token.getCharPositionInLine() + 1);
        if (this.includeSourceOffset) {
            builder.setCurrentOffset(token.getStartIndex());
            builder.setEndOffset(token.getStopIndex());
        }
        return builder;
    }

    public SourcePosition.Builder fromSyntaxError(Object offendingSymbol, Recognizer<?, ?> recognizer) {
        if (offendingSymbol instanceof Token) {
            Token offendingToken = (Token)offendingSymbol;
            return this.fromToken(offendingToken);
        }
        if (recognizer instanceof Lexer) {
            Lexer lexer = (Lexer)recognizer;
            SourcePosition.Builder builder = SourcePosition.newBuilder().setFileIndex(this.sourceFileIndex).setLine(lexer.getLine()).setColumn(lexer.getCharPositionInLine() + 1);
            if (this.includeSourceOffset) {
                int currentIndex = lexer.getCharIndex();
                builder.setCurrentOffset(currentIndex);
                builder.setCurrentOffset(currentIndex);
            }
            return builder;
        }
        throw new RuntimeException("SyntaxError missing information.");
    }

    public SourcePosition.Builder getEmptyPosition() {
        return SourcePosition.newBuilder().setFileIndex(this.sourceFileIndex);
    }

    public boolean includeSourceOffset() {
        return this.includeSourceOffset;
    }
}

