/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.common;

import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.i18n.MessageReference;
import java.util.List;
import java.util.Locale;

public class CompilationIssueUtils {
    private CompilationIssueUtils() {
    }

    public static Issue makeError(Identifier identifier, MessageReference messageReference, String ... params) {
        return CompilationIssueUtils.makeError(identifier.getSourcePosition(), messageReference, params);
    }

    public static Issue makeError(SourcePosition sourcePosition, MessageReference messageReference, String ... params) {
        return CompilationIssueUtils.makeIssue(sourcePosition, Issue.Severity.ERROR, messageReference, params);
    }

    public static Issue makeError(SourcePosition sourcePosition, Exception ex) {
        return Issue.newBuilder().setSeverity(Issue.Severity.ERROR).setSourcePosition(sourcePosition).setDescription(ex.getMessage()).build();
    }

    public static Issue makeWarning(Identifier identifier, MessageReference messageReference, String ... params) {
        return CompilationIssueUtils.makeWarning(identifier.getSourcePosition(), messageReference, params);
    }

    public static Issue makeWarning(SourcePosition sourcePosition, MessageReference messageReference, String ... params) {
        return CompilationIssueUtils.makeIssue(sourcePosition, Issue.Severity.WARNING, messageReference, params);
    }

    private static Issue makeIssue(SourcePosition sourcePosition, Issue.Severity severity, MessageReference messageReference, String[] params) {
        return Issue.newBuilder().setSeverity(severity).setSourcePosition(sourcePosition).setDescription(messageReference.getMessage(Locale.ENGLISH).toString(params)).build();
    }

    public static boolean hasCompileError(List<Issue> issues) {
        for (Issue issue : issues) {
            if (issue.getSeverity() != Issue.Severity.ERROR) continue;
            return true;
        }
        return false;
    }
}

