/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.common;

import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import java.util.Locale;

public class RegexValidator {
    private static final int MAX_REGEX_LENGTH = 4096;
    private static final int MAX_GROUPING = 100;
    private static final int MAX_GROUPING_DEPTH = 20;

    private RegexValidator() {
    }

    public static Pattern validateAndCompile(CharSequence regex) throws IllegalArgumentException {
        if (regex.length() > 4096) {
            throw RegexValidator.makeTooLongRegex(4096, regex.toString());
        }
        int totalGrouping = 0;
        int depth = 0;
        for (int i = 0; i < regex.length(); ++i) {
            char ch = regex.charAt(i);
            if (ch == '\\') {
                ++i;
            }
            if (ch == '(') {
                ++depth;
                if (++totalGrouping > 100) {
                    throw RegexValidator.makeTooManyGroupings(100, regex.toString());
                }
                if (depth <= 20) continue;
                throw RegexValidator.makeTooManyNestedGroupings(20, regex.toString());
            }
            if (ch != ')' || --depth >= 0) continue;
            throw RegexValidator.makeInvalidRegexPattern(regex.toString());
        }
        if (depth != 0) {
            throw RegexValidator.makeInvalidRegexPattern(regex.toString());
        }
        try {
            return Pattern.compile(regex.toString());
        }
        catch (PatternSyntaxException e) {
            throw RegexValidator.makeInvalidRegexPattern(regex.toString());
        }
    }

    private static IllegalArgumentException makeInvalidRegexPattern(String pattern) {
        return new IllegalArgumentException(FirebaseRulesMessages.INVALID_REGEX_PATTERN.get(Locale.ENGLISH).toString(pattern));
    }

    private static IllegalArgumentException makeTooLongRegex(int expectedLength, String pattern) {
        return new IllegalArgumentException(FirebaseRulesMessages.REGEX_TOO_LONG.get(Locale.ENGLISH).toString(Integer.toString(expectedLength), pattern));
    }

    private static IllegalArgumentException makeTooManyGroupings(int expectedGroupings, String pattern) {
        return new IllegalArgumentException(FirebaseRulesMessages.REGEX_TOO_MANY_GROUPING.get(Locale.ENGLISH).toString(Integer.toString(expectedGroupings), pattern));
    }

    private static IllegalArgumentException makeTooManyNestedGroupings(int expectedNestedGroupings, String pattern) {
        return new IllegalArgumentException(FirebaseRulesMessages.REGEX_TOO_DEEP.get(Locale.ENGLISH).toString(Integer.toString(expectedNestedGroupings), pattern));
    }
}

