/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.common;

import com.google.common.collect.ImmutableMap;

public enum TypeName {
    BOOL("bool"),
    BYTES("bytes"),
    CONSTRAINT("constraint"),
    DURATION("duration"),
    FLOAT("float"),
    INT("int"),
    LATLNG("latlng"),
    LIST("list"),
    SET("set"),
    NUMBER("number"),
    MAP("map"),
    STRING("string"),
    TIMESTAMP("timestamp"),
    PATH_TEMPLATE("path");

    private String friendlyName;
    public static final ImmutableMap<String, TypeName> typesMap;

    private TypeName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public static TypeName fromString(String friendlyName) {
        try {
            return typesMap.get(friendlyName);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String toString() {
        return this.friendlyName;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    static {
        ImmutableMap.Builder<String, TypeName> mapBuilder = ImmutableMap.builder();
        for (TypeName typeName : TypeName.values()) {
            mapBuilder.put(typeName.friendlyName, typeName);
        }
        typesMap = mapBuilder.build();
    }
}

