/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.common;

import com.google.common.net.PercentEscaper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public class UrlEncoder {
    private static final PercentEscaper ESCAPER = new PercentEscaper("-_.*:@~&'", true);

    private UrlEncoder() {
    }

    public static String decode(String segment) throws UrlDecodingException {
        try {
            return URLDecoder.decode(segment, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new UrlDecodingException(e.getMessage(), e);
        }
    }

    public static String encode(String segment) {
        return ESCAPER.escape(segment);
    }

    public static class UrlDecodingException
    extends Exception {
        public UrlDecodingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

