/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.policy;

import java.util.ArrayList;
import java.util.List;

public class FileLineUtils {
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';

    private FileLineUtils() {
    }

    public static List<Integer> calculateLineOffsets(String source) {
        ArrayList<Integer> lineStarts = new ArrayList<Integer>();
        for (int i = 0; i < source.length(); ++i) {
            char nextChar;
            char ch = source.charAt(i);
            if (ch == '\n') {
                lineStarts.add(i + 1);
                continue;
            }
            if (ch != '\r') continue;
            if (source.length() > i + 1 && (nextChar = source.charAt(i + 1)) == '\n') {
                ++i;
            }
            lineStarts.add(i + 1);
        }
        return lineStarts;
    }
}

