/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.policy;

import com.google.api.expr.SourceInfo;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.Metadata;
import com.google.firebase.rules.lang.policy.FileLineUtils;
import com.google.firebase.rules.v1.File;
import com.google.firebase.rules.v1.SourcePosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IdGenerator {
    public long getId(SourcePosition var1);

    public static class MetadataGatheringIdGenerator
    implements IdGenerator {
        private ImmutableList<File> files;
        private long id = 1L;
        private Map<String, Map<Long, Integer>> offsets = new HashMap<String, Map<Long, Integer>>();
        private Map<String, String> fileSources = new HashMap<String, String>();

        public MetadataGatheringIdGenerator(ImmutableList<File> files) {
            this.files = files;
            for (File file : files) {
                this.fileSources.put(file.getName(), file.getContent());
            }
        }

        @Override
        public long getId(SourcePosition sourcePosition) {
            long assignedId = this.id++;
            String fileName = ((File)this.files.get(sourcePosition.getFileIndex())).getName();
            Map fileOffsets = this.offsets.computeIfAbsent(fileName, s -> new HashMap());
            fileOffsets.put(assignedId, sourcePosition.getCurrentOffset());
            return assignedId;
        }

        public Metadata toMetadata() {
            Metadata.Builder metadata = Metadata.newBuilder();
            this.offsets.forEach((fileName, idPositions) -> {
                List<Integer> fileOffsets = FileLineUtils.calculateLineOffsets(this.fileSources.get(fileName));
                metadata.putSourceInfoMap(fileName, SourceInfo.newBuilder().setSyntaxVersion("rules2").addAllLineOffsets(fileOffsets).putAllPositions(idPositions).build());
            });
            return metadata.build();
        }
    }

    public static class SimpleIdGenerator
    implements IdGenerator {
        private long id = 1L;

        @Override
        public long getId(SourcePosition sourcePosition) {
            return this.id++;
        }
    }
}

