/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.FunctionVisitor;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.tree.PreOrderTreeWalker;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.jgrapht.alg.cycle.TarjanSimpleCycles;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedPseudograph;

@NotThreadSafe
public class CycleDetectorAndDepthValidator
implements SemanticValidator<TreeNode<Scope>> {
    private static final Function<Identifier, String> ID_TO_NAME_TRANSFORMER = new Function<Identifier, String>(){

        @Override
        @Nullable
        public String apply(Identifier identifier) {
            return identifier.getName();
        }
    };
    private static final String CALL_SEPARATOR = "->";
    private static final String COMMA = ",";
    private static final int MAX_ALLOWED_FUNCTION_DEPTH = 20;
    private final List<Issue> issues = Lists.newArrayList();
    private final DirectedPseudograph<Identifier, DefaultEdge> callGraph = new DirectedPseudograph(DefaultEdge.class);

    @Override
    public List<Issue> check(TreeNode<Scope> root) {
        this.constructCallGraph(root);
        this.checkForCycle();
        this.checkForMaxDepthSize();
        return this.issues;
    }

    private void constructCallGraph(TreeNode<Scope> root) {
        new PreOrderTreeWalker<Scope>().walk(root, node -> {
            for (com.google.firebase.rules.runtime.v1.Function function : ((Scope)node.getValue()).functions()) {
                new FunctionVisitor(function, node, this.callGraph, true).visit();
            }
        });
    }

    private void checkForCycle() {
        TarjanSimpleCycles<Identifier, DefaultEdge> detector = new TarjanSimpleCycles<Identifier, DefaultEdge>(this.callGraph);
        List cycles = detector.findSimpleCycles();
        for (List<Identifier> list : cycles) {
            if (list.size() > 1) {
                String cycleString = this.joinIdentifiers(list, COMMA);
                this.issues.add(CompilationIssueUtils.makeError(list.iterator().next(), (MessageReference)FirebaseRulesMessages.ERROR_CALL_CYCLE_DETECTED, cycleString));
            }
            if (list.size() != 1) continue;
            this.issues.add(CompilationIssueUtils.makeError(list.iterator().next(), (MessageReference)FirebaseRulesMessages.ERROR_RECURSIVE_CALL_NOT_ALLOWED, new String[0]));
        }
    }

    private void checkForMaxDepthSize() {
        if (this.issues.isEmpty()) {
            for (Identifier vertex : this.callGraph.vertexSet()) {
                if (this.callGraph.inDegreeOf(vertex) != 0) continue;
                this.checkMaxDepthRecursively(vertex, new ArrayDeque<Identifier>());
            }
        }
    }

    private void checkMaxDepthRecursively(Identifier vertex, Deque<Identifier> callHierarchy) {
        Set edges = this.callGraph.outgoingEdgesOf(vertex);
        callHierarchy.add(vertex);
        for (DefaultEdge edge : edges) {
            Identifier outGoing = (Identifier)this.callGraph.getEdgeTarget(edge);
            if (callHierarchy.size() > 20) {
                this.issues.add(CompilationIssueUtils.makeError(outGoing, (MessageReference)FirebaseRulesMessages.ERROR_REACHED_MAX_ALLOWED_FUNCTION_CALL_DEPTH, Long.toString(20L), this.joinIdentifiers(callHierarchy, CALL_SEPARATOR)));
                callHierarchy.pop();
                return;
            }
            this.checkMaxDepthRecursively(outGoing, callHierarchy);
        }
        callHierarchy.pop();
    }

    private String joinIdentifiers(Collection<Identifier> identifiers, String separator) {
        return Joiner.on(separator).join(Iterables.transform(identifiers, ID_TO_NAME_TRANSFORMER));
    }
}

