/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.firebase.rules.lang.common.FirebaseRulesLangOptions;
import com.google.firebase.rules.lang.semantic.CycleDetectorAndDepthValidator;
import com.google.firebase.rules.lang.semantic.DuplicateLetBindingInScope;
import com.google.firebase.rules.lang.semantic.FunctionRedefinitionValidator;
import com.google.firebase.rules.lang.semantic.GlobMatchRuleWithChild;
import com.google.firebase.rules.lang.semantic.GlobMatchRuleWithChildGlobMatchRule;
import com.google.firebase.rules.lang.semantic.LetBindingsInRulesV1;
import com.google.firebase.rules.lang.semantic.MatchRuleMaxDepthValidator;
import com.google.firebase.rules.lang.semantic.RegexCheck;
import com.google.firebase.rules.lang.semantic.RepeatedServiceDefinition;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.lang.semantic.TypeCheckValidator;
import com.google.firebase.rules.lang.semantic.VariableRedefinitionValidator;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.RulesetAstOrBuilder;
import com.google.firebase.rules.runtime.v1.ServiceRule;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.tree.TreeNodeImpl;
import com.google.firebase.rules.v1.Issue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DefaultSemanticValidator
implements SemanticValidator<RulesetAstOrBuilder> {
    private final ImmutableList<SemanticValidator<TreeNode<Scope>>> validators;

    public DefaultSemanticValidator(FirebaseRulesLangOptions options) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(new FunctionRedefinitionValidator());
        builder.add(new VariableRedefinitionValidator());
        builder.add(new CycleDetectorAndDepthValidator());
        builder.add(new MatchRuleMaxDepthValidator());
        builder.add(new GlobMatchRuleWithChild());
        builder.add(new RepeatedServiceDefinition());
        builder.add(new DuplicateLetBindingInScope());
        builder.add(new LetBindingsInRulesV1());
        builder.add(new RegexCheck());
        if (options.typeCheck()) {
            builder.add(new TypeCheckValidator());
        }
        builder.add(new GlobMatchRuleWithChildGlobMatchRule());
        this.validators = builder.build();
    }

    @Override
    public List<Issue> check(RulesetAstOrBuilder rulesetAst) {
        ArrayList<Issue> issues = Lists.newArrayList();
        TreeNode<Scope> root = DefaultSemanticValidator.walk(rulesetAst);
        for (SemanticValidator semanticValidator : this.validators) {
            issues.addAll(semanticValidator.check(root));
        }
        return issues;
    }

    private static TreeNode<Scope> walk(RulesetAstOrBuilder rulesetAst) {
        TreeNode<Scope> root = TreeNodeImpl.makeRoot(Scope.fromRulesetAst(rulesetAst));
        for (ServiceRule serviceRule : rulesetAst.getServiceRulesList()) {
            TreeNode<Scope> serviceRuleScope = root.makeChild(Scope.fromServiceRule(serviceRule));
            for (MatchRule matchRule : serviceRule.getMatchRulesList()) {
                DefaultSemanticValidator.processMatchRule(serviceRuleScope, matchRule);
            }
        }
        return root;
    }

    private static void processMatchRule(TreeNode<Scope> parent, MatchRule matchRule) {
        parent = parent.makeChild(Scope.fromMatchRule(matchRule));
        for (MatchRule childRule : matchRule.getMatchRulesList()) {
            DefaultSemanticValidator.processMatchRule(parent, childRule);
        }
    }
}

