/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.common.AbstractAstVisitor;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.Binding;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DuplicateLetBindingInScope
extends AbstractAstVisitor
implements SemanticValidator<TreeNode<Scope>> {
    private final ImmutableList.Builder<Issue> issues = ImmutableList.builder();

    @Override
    public List<Issue> check(TreeNode<Scope> node) {
        this.visitAst(node.getValue().ruleset());
        return this.issues.build();
    }

    @Override
    protected void visitFunction(Function fn) {
        HashSet<String> bindings = new HashSet<String>();
        for (Identifier id : fn.getParamsIdsList()) {
            bindings.add(id.getName());
        }
        Expression expr = fn.getBody();
        while (expr.hasBinding()) {
            for (Binding b : expr.getBinding().getBindingsList()) {
                if (bindings.add(b.getId().getName())) continue;
                this.issues.add((Object)CompilationIssueUtils.makeError(b.getId().getSourcePosition(), (MessageReference)FirebaseRulesMessages.ERROR_DUPLICATE_LET_BINDING, b.getId().getName()));
            }
            expr = expr.getBinding().getBody();
        }
        super.visitFunction(fn);
    }
}

