/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.api.expr.Decl;
import com.google.api.expr.Type;
import com.google.api.tools.expr.checker.Env;
import com.google.api.tools.expr.checker.ModelTypeProvider;
import com.google.api.tools.expr.checker.TypeProvider;
import com.google.api.tools.expr.checker.Types;
import com.google.api.tools.expr.features.ExprFeatures;
import com.google.api.tools.expr.parser.Errors;
import com.google.api.tools.framework.model.Model;
import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.PolicyPath;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.type.LatLng;

public class FirebaseRulesTypes {
    static final Type BOOL = Types.BOOL;
    static final Type STRING = Types.STRING;
    static final Type DOUBLE = Types.DOUBLE;
    static final Type INT = Types.INT64;
    static final Type DYN = Types.DYN;
    static final Type DURATION = Types.DURATION;
    static final Type TIMESTAMP = Types.TIMESTAMP;
    static final Type LAT_LNG = Types.createMessage((String)LatLng.getDescriptor().getFullName());
    static final Type T = Types.createTypeParam((String)"T");
    static final ImmutableList<String> _T_ = ImmutableList.of("T");
    static final Type V = Types.createTypeParam((String)"V");
    static final ImmutableList<String> _T_V_ = ImmutableList.of("T", "V");
    static final Type LIST_T = Types.createList((Type)T);
    static final Type LIST_V = Types.createList((Type)V);
    static final Type MAP_T_V = Types.createMap((Type)T, (Type)V);
    static final Type PATH = Types.createMessage((String)PolicyPath.getDescriptor().getFullName());
    static final Type LIST_OF_STRINGS;
    static final Type MAP_KEYS_LISTS;
    static final Type MAP_OF_STRING_DYN;
    static final Env.DeclGroup BUILTINS;
    static final Model STANDARD_MODEL;

    static Env makeEnv(Errors errors) {
        Env env = Env.unconfigured((Errors)errors, (TypeProvider)new ModelTypeProvider(errors, STANDARD_MODEL), (ExprFeatures[])new ExprFeatures[0]);
        env.enterScope();
        for (Decl func : BUILTINS.getFunctions().values()) {
            env.add(func);
        }
        for (Decl id : BUILTINS.getIdents().values()) {
            env.add(id);
        }
        return env;
    }

    static Decl declare(String name, Type type) {
        return new Env.IdentBuilder(name).type(type).build();
    }

    static {
        MAP_KEYS_LISTS = LIST_OF_STRINGS = Types.createList((Type)DYN);
        MAP_OF_STRING_DYN = Types.createMap((Type)STRING, (Type)DYN);
        STANDARD_MODEL = ModelTypeProvider.createModel((DescriptorProtos.FileDescriptorSet)DescriptorProtos.FileDescriptorSet.newBuilder().addFile(Timestamp.getDescriptor().getFile().toProto()).addFile(Duration.getDescriptor().getFile().toProto()).addFile(PolicyPath.getDescriptor().getFile().toProto()).build());
        Errors errors = new Errors("", null);
        Env env = Env.unconfigured((Errors)errors, (TypeProvider)new ModelTypeProvider(errors, STANDARD_MODEL), (ExprFeatures[])new ExprFeatures[]{ExprFeatures.DEDUPE_REFERENCE_MAP_FUNCTION_NAMES});
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInMathOperator.ADD.getFunctionName()).add("add_int_int", INT, new Type[]{INT, INT}).doc("arithmetic").add("add_double_double", DOUBLE, new Type[]{DOUBLE, DOUBLE}).doc("Adds two number.").add("add_double_int", DOUBLE, new Type[]{DOUBLE, INT}).doc("Adds two number.").add("add_int_double", DOUBLE, new Type[]{INT, DOUBLE}).doc("Adds two number.").add("concat_string", STRING, new Type[]{STRING, STRING}).doc("Concatenates two strings.").add("add_duration_duration", DURATION, new Type[]{DURATION, DURATION}).doc("Adds two duration.").add("add_timestamp_duration", TIMESTAMP, new Type[]{TIMESTAMP, DURATION}).doc("Adds duration to a timestamp.").add("add_duration_timestamp", TIMESTAMP, new Type[]{DURATION, TIMESTAMP}).doc("Adds duration to a timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInMathOperator.MINUS.getFunctionName()).add("minus_int_int", INT, new Type[]{INT, INT}).doc("Subtracts one number from another.").add("minus_double_double", DOUBLE, new Type[]{DOUBLE, DOUBLE}).doc("Subtracts one number from another.").add("minus_double_int", DOUBLE, new Type[]{DOUBLE, INT}).doc("Subtracts one number from another.").add("minus_int_double", DOUBLE, new Type[]{INT, DOUBLE}).doc("Subtracts one number from another.").add("minus_duration_duration", DURATION, new Type[]{DURATION, DURATION}).doc("Subtracts one duration from another.").add("minus_timestamp_timestamp", DURATION, new Type[]{TIMESTAMP, TIMESTAMP}).doc("Returns the duration difference between two timestamp.").add("minus_timestamp_duration", TIMESTAMP, new Type[]{TIMESTAMP, DURATION}).doc("Subtracts a duration from a timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInUnaryOperator.NEGATE_NUMBER.getFunctionName()).add("negate_int", INT, new Type[]{INT}).doc("Negates a number.").add("negate_double64", DOUBLE, new Type[]{DOUBLE}).doc("Negates a number.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInMathOperator.MULTIPLY.getFunctionName()).add("mul_int_int", INT, new Type[]{INT, INT}).doc("Multiplies two numbers.").add("mul_double_double", DOUBLE, new Type[]{DOUBLE, DOUBLE}).doc("Multiplies two numbers.").add("mul_double_int", DOUBLE, new Type[]{DOUBLE, INT}).doc("Multiplies two numbers.").add("mul_int_double", DOUBLE, new Type[]{INT, DOUBLE}).doc("Multiplies two numbers.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInMathOperator.DIVIDE.getFunctionName()).add("div_int_int", INT, new Type[]{INT, INT}).doc("Divides two numbers.").add("div_double_double", DOUBLE, new Type[]{DOUBLE, DOUBLE}).doc("Divides two numbers.").add("div_double_int", DOUBLE, new Type[]{DOUBLE, INT}).doc("Divides two numbers.").add("div_int_double", DOUBLE, new Type[]{INT, DOUBLE}).doc("Divides two numbers.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInMathOperator.MODULUS.getFunctionName()).add("mod_int_int", INT, new Type[]{INT, INT}).doc("Returns the remainder of the division.").add("mod_double_double", DOUBLE, new Type[]{DOUBLE, DOUBLE}).doc("Returns the remainder of the division").add("mod_double_int", DOUBLE, new Type[]{DOUBLE, INT}).doc("Returns the remainder of the division").add("mod_int_double", DOUBLE, new Type[]{INT, DOUBLE}).doc("Returns the remainder of the division").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.EQUALS.getFunctionName()).add("equals", BOOL, new Type[]{DYN, DYN}).doc("Compares two objects and returns true if two objects are equal.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.NOT_EQUALS.getFunctionName()).add("not_equals", BOOL, new Type[]{DYN, DYN}).doc("Compares two objects and returns false if two objects are equal.").build());
        Decl less = new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.LESS_THAN.getFunctionName()).add("less_int_int", BOOL, new Type[]{INT, INT}).doc("Comparison operator for numbers.").add("less_double_double", BOOL, new Type[]{DOUBLE, DOUBLE}).doc("Comparison operator for numbers.").add("less_int_double", BOOL, new Type[]{INT, DOUBLE}).doc("Comparison operator for numbers.").add("less_double_int", BOOL, new Type[]{DOUBLE, INT}).doc("Comparison operator for numbers.").add("less_string", BOOL, new Type[]{STRING, STRING}).doc("Comparison operator for strings.").add("less_timestamp", BOOL, new Type[]{TIMESTAMP, TIMESTAMP}).doc("Comparison operator for timestamps.").add("less_duration", BOOL, new Type[]{DURATION, DURATION}).doc("Comparison operator for durations.").doc("ordering").build();
        env.add(less);
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.LESS_THAN_OR_EQUALS.getFunctionName()).sameAs(less, "less", "less_equals").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.GREATER_THAN.getFunctionName()).sameAs(less, "less", "greater").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.GREATER_THAN_OR_EQUALS.getFunctionName()).sameAs(less, "less", "greater_equals").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.IS_TYPE.getFunctionName()).add("is_type", BOOL, new Type[]{DYN, STRING}).doc("is of type.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_AND.getFunctionName()).add("logical_and", BOOL, new Type[]{BOOL, BOOL}).doc("logical and operator.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_OR.getFunctionName()).add("logical_or", BOOL, new Type[]{BOOL, BOOL}).doc("logical or operator.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInUnaryOperator.BOOLEAN_NOT.getFunctionName()).add("logical_not", BOOL, new Type[]{BOOL}).doc("logical not operator.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.TO_INT.getFunctionName()).add("to_int_int", INT, new Type[]{INT}).doc("Converts to int.").add("to_int_double", INT, new Type[]{DOUBLE}).doc("Converts to int.").add("to_int_string", INT, new Type[]{STRING}).doc("Converts to int.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.TO_FLOAT.getFunctionName()).add("to_double_int", DOUBLE, new Type[]{INT}).doc("Converts to double.").add("to_double_double", DOUBLE, new Type[]{DOUBLE}).doc("Converts to double.").add("to_double_string", DOUBLE, new Type[]{STRING}).doc("Converts to double.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.TO_STRING.getFunctionName()).add("to_string_int", STRING, new Type[]{INT}).doc("Converts to string.").add("to_string_double", STRING, new Type[]{DOUBLE}).doc("Converts to string.").add("to_string_string", STRING, new Type[]{STRING}).doc("Converts to string.").add("to_string_bool", STRING, new Type[]{BOOL}).doc("Converts to string.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.DURATION_VALUE.getFunctionName()).add("duration_with_unit", DURATION, new Type[]{INT, STRING}).doc("Creations a duration. e.g 1 'w' -> 1w duration").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.DURATION_TIME.getFunctionName()).add("duration_for_numbers", DURATION, new Type[]{INT, INT, INT, INT}).doc("Creations a duration. duration.time(int hrs, int mins, int secs, int nanos).").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.LATLNG_VALUE.getFunctionName()).add("to_latlng_double_double", LAT_LNG, new Type[]{DOUBLE, DOUBLE}).doc("Creations a latlng.").add("to_latlng_int_int", LAT_LNG, new Type[]{INT, INT}).doc("Creations a latlng.").add("to_latlng_double_int", LAT_LNG, new Type[]{DOUBLE, INT}).doc("Creations a latlng.").add("to_latlng_int_double", LAT_LNG, new Type[]{INT, DOUBLE}).doc("Creations a latlng.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.TIMESTAMP_VALUE.getFunctionName()).add("timestamp_epoch", TIMESTAMP, new Type[]{INT}).doc("Creates timestamp from epoch.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.TIMESTAMP_DATE.getFunctionName()).add("timestamp_date", TIMESTAMP, new Type[]{INT, INT, INT}).doc("Creates timestamp from year,month,day.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInTypeConversionFunction.PATH.getFunctionName()).add("path constructor", PATH, new Type[]{STRING}).doc("Creates a path by parsing the provided string.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.IS_NAN.getFunctionName()).add("is_nan_double", BOOL, new Type[]{DOUBLE}).doc("Returns true if not a number.").add("is_nan_int", BOOL, new Type[]{INT}).doc("Returns true if not a number.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.IS_INFINITY.getFunctionName()).add("is_nan_double", BOOL, new Type[]{DOUBLE}).doc("Returns true if is infinity.").add("is_nan_int", BOOL, new Type[]{INT}).doc("Returns true if is infinity").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.FLOOR.getFunctionName()).add("floor_double", DOUBLE, new Type[]{DOUBLE}).doc("Returns floor for the number.").add("floor_int", DOUBLE, new Type[]{INT}).doc("Returns floor for the number.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.CEIL.getFunctionName()).add("ceil_double", DOUBLE, new Type[]{DOUBLE}).doc("Returns ceil for the number.").add("ceil_int", DOUBLE, new Type[]{INT}).doc("Returns ceil for the number.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.ROUND.getFunctionName()).add("round_double", INT, new Type[]{DOUBLE}).doc("Returns the rounded number to the closest integer.").add("round_int", INT, new Type[]{INT}).doc("Returns the rounded number to the closest integer.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.ABS.getFunctionName()).add("abs_double", DOUBLE, new Type[]{DOUBLE}).doc("Returns the absolute value.").add("round_int", INT, new Type[]{INT}).doc("Returns the absolute value.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.DURATION_ABS.getFunctionName()).add("duration_abs", DURATION, new Type[]{DURATION}).doc("Returns the absolute value for duration.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.StringMembers.SIZE.getFunctionName(), true).add("string_size", INT, new Type[]{STRING}).doc("Returns number of characters in the string.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), true).add("string_index_at", STRING, new Type[]{STRING, INT}).doc("Returns char at index.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE.getFunctionName(), true).add("string_range", STRING, new Type[]{STRING, DYN, DYN}).doc("Returns a sub string using from and to indexes.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.StringMembers.SPLIT.getFunctionName(), true).add("string_split", LIST_OF_STRINGS, new Type[]{STRING, STRING}).doc("Splits a string in a list using a regular expression pattern.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.StringMembers.MATCHES.getFunctionName(), true).add("string_matches", BOOL, new Type[]{STRING, STRING}).doc("Checks if a string matches a regular expression..").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.StringMembers.TRIM.getFunctionName(), true).add("string_trim", STRING, new Type[]{STRING}).doc("Trims the string.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.StringMembers.UPPER.getFunctionName(), true).add("string_upper", STRING, new Type[]{STRING}).doc("Returns uppercase of string.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.StringMembers.LOWER.getFunctionName(), true).add("string_lower", STRING, new Type[]{STRING}).doc("Returns lowercase of string.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.StringMembers.REPLACE.getFunctionName(), true).add("string_replace", STRING, new Type[]{STRING}).doc("Replaces occurances of a regex in a string.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.DurationMembers.NANOS.getFunctionName(), true).add("duration_nanos", INT, new Type[]{DURATION}).doc("Returns nanos second of duration.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.DurationMembers.SECONDS.getFunctionName(), true).add("duration_seconds", INT, new Type[]{DURATION}).doc("Returns seconds section of duration.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.LatLngMembers.LATITUDE.getFunctionName(), true).add("latlng_latitude", DOUBLE, new Type[]{LAT_LNG}).doc("Returns latitude of the duration.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.LatLngMembers.LONGITUDE.getFunctionName(), true).add("latlng_longitude", DOUBLE, new Type[]{LAT_LNG}).doc("Returns longitude of the duration.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.LatLngMembers.DISTANCE.getFunctionName(), true).add("latlng_distance", DOUBLE, new Type[]{LAT_LNG, LAT_LNG}).doc("Returns the distance between two points.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.NANOS.getFunctionName(), true).add("timestamp_nanos", INT, new Type[]{TIMESTAMP}).doc("Returns nanoseconds of the timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.SECONDS.getFunctionName(), true).add("timestamp_seconds", INT, new Type[]{TIMESTAMP}).doc("Returns seconds of the timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.MINUTES.getFunctionName(), true).add("timestamp_minutes", INT, new Type[]{TIMESTAMP}).doc("Returns minutes of the timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.HOURS.getFunctionName(), true).add("timestamp_hours", INT, new Type[]{TIMESTAMP}).doc("Returns hours of the timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.DAY.getFunctionName(), true).add("timestamp_day", INT, new Type[]{TIMESTAMP}).doc("Returns day of the timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.MONTH.getFunctionName(), true).add("timestamp_month", INT, new Type[]{TIMESTAMP}).doc("Returns month of the timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.YEAR.getFunctionName(), true).add("timestamp_year", INT, new Type[]{TIMESTAMP}).doc("Returns year of the timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.DAY_OF_YEAR.getFunctionName(), true).add("timestamp_day_of_year", INT, new Type[]{TIMESTAMP}).doc("Returns the day of the year for timestamp.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.DAY_OF_WEEK.getFunctionName(), true).add("timestamp_nanos", INT, new Type[]{TIMESTAMP}).doc("Returns the day of the week for timestamp (monday = 1, sunday = 7).").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.DATE.getFunctionName(), true).add("timestamp_date", TIMESTAMP, new Type[]{TIMESTAMP}).doc("Returns a timestamp from the beginning of the day.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.TO_MILLIS.getFunctionName(), true).add("timestamp_to_mills", INT, new Type[]{TIMESTAMP}).doc("Returns milliseconds from epoch.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TimestampMembers.TIME.getFunctionName(), true).add("timestamp_time", DURATION, new Type[]{TIMESTAMP}).doc("Returns duration passed from beginning of the day.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.ListMembers.SIZE.getFunctionName(), true).add("list_size", _T_, INT, new Type[]{LIST_T}).doc("Returns number of items in list.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.ListMembers.CONCAT.getFunctionName(), true).add("concat", _T_, LIST_T, new Type[]{LIST_T}).doc("Concatenates this list with another list.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), true).add("list_index_at", _T_, T, new Type[]{LIST_T, INT}).doc("Returns item at index.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE.getFunctionName(), true).add("Lists_range", _T_, LIST_T, new Type[]{LIST_T, DYN, DYN}).doc("Returns a sub list using from and to indexes.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.IN.getFunctionName(), true).add("list_in", _T_, BOOL, new Type[]{LIST_T, T}).doc("Returns if the item in list.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.ListMembers.HAS_ALL.getFunctionName(), true).add("list_has_all", _T_, BOOL, new Type[]{LIST_T, LIST_T}).doc("Checks if the list is super set of provided list.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.ListMembers.HAS_ANY.getFunctionName(), true).add("list_has_any", _T_, BOOL, new Type[]{LIST_T, LIST_T}).doc("Returns if any of the element exists in the list.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.ListMembers.JOIN.getFunctionName(), true).add("list_join", STRING, new Type[]{LIST_OF_STRINGS, STRING}).doc("Joins all the elements int the provided list of strings.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.MapMembers.SIZE.getFunctionName(), true).add("map_size", _T_V_, INT, new Type[]{MAP_T_V}).doc("Returns number of items in map.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), true).add("map_index_at", _T_V_, V, new Type[]{MAP_T_V, T}).doc("Returns item with the key.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.IN.getFunctionName(), true).add("map_in", _T_V_, BOOL, new Type[]{MAP_T_V, T}).doc("Checks if the item in map keys.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.MapMembers.KEYS.getFunctionName(), true).add("map_keys", _T_V_, MAP_KEYS_LISTS, new Type[]{MAP_T_V}).doc("Returns keys of the map as a list.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.MapMembers.VALUES.getFunctionName(), true).add("map_values", _T_V_, LIST_V, new Type[]{MAP_T_V}).doc("Returns values of the map as a list.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.PathDeSugarMethods.TO_PATH.getFunctionName()).add("path_interpolation_string", PATH, new Type[]{STRING}).doc("String interpolation within a path. Generated by desugarer.").add("path_interpolation_path", PATH, new Type[]{PATH}).doc("Path interpolation within a path. Generated by desugarer.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.PathDeSugarMethods.CONCAT.getFunctionName()).add("path_concat", PATH, new Type[]{PATH, PATH}).doc("Concatenates two paths. Generated by desugarer.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.PathMembers.BIND.getFunctionName(), true).add("path_bind", PATH, new Type[]{PATH, MAP_OF_STRING_DYN}).doc("Binds the parameters inside a templated path.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), true).add("path_lookup", DYN, new Type[]{PATH, STRING}).doc("Lookup parameters inside the path.").build());
        env.add(new Env.FunctionBuilder(FunctionTemplate.TO_DYN.getFunctionName()).add("to_dyn", _T_, Types.DYN, new Type[]{T}).doc("type conversion").build());
        env.tryLookupIdent("", PolicyPath.getDescriptor().getFullName());
        env.tryLookupIdent("", PolicyPath.Capture.getDescriptor().getFullName());
        env.tryLookupIdent("", PolicyPath.MultiCapture.getDescriptor().getFullName());
        env.tryLookupIdent("", PolicyPath.Segment.getDescriptor().getFullName());
        if (env.getErrorContext().getErrorCount() > 0) {
            String string = String.valueOf(env.getErrorContext().getAllErrorsAsString());
            throw new RuntimeException(string.length() != 0 ? "unable to build the standard environment for rules evaluation".concat(string) : new String("unable to build the standard environment for rules evaluation"));
        }
        BUILTINS = env.getDeclGroup().immutableCopy();
    }
}

