/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.List;
import java.util.function.Consumer;

public final class GlobMatchRuleWithChildGlobMatchRule
implements SemanticValidator<TreeNode<Scope>> {
    @Override
    public List<Issue> check(TreeNode<Scope> root) {
        ImmutableList.Builder issues = ImmutableList.builder();
        GlobMatchRuleWithChildGlobMatchRule.walkTree(root, false, issues::add);
        return issues.build();
    }

    private static void walkTree(TreeNode<Scope> root, boolean parentHasGlob, Consumer<Issue> issues) {
        boolean hasGlob = false;
        switch (root.getValue().level()) {
            case RULESET: {
                if (!GlobMatchRuleWithChildGlobMatchRule.rulesVersionDisallowsNestedGlobs(root.getValue().ruleset().getVersion())) break;
                return;
            }
            case SERVICE: {
                break;
            }
            case MATCH: {
                MatchRule rule = root.getValue().match();
                hasGlob = rule.getPath().getSegmentsList().stream().anyMatch(Path.PathSegment::hasGlobCapture);
                if (!hasGlob || !parentHasGlob) break;
                issues.accept(CompilationIssueUtils.makeError(rule.getSourcePosition(), (MessageReference)FirebaseRulesMessages.ONLY_ONE_GLOB_PERMITTED, new String[0]));
            }
        }
        for (TreeNode<Scope> child : root.getChildren()) {
            GlobMatchRuleWithChildGlobMatchRule.walkTree(child, hasGlob || parentHasGlob, issues);
        }
    }

    private static boolean rulesVersionDisallowsNestedGlobs(RulesetAst.Version rulesVersion) {
        switch (rulesVersion) {
            case VERSION_UNSPECIFIED: 
            case VERSION_1: {
                return true;
            }
            case VERSION_2: {
                return false;
            }
        }
        throw new AssertionError((Object)"Unknown rules version");
    }
}

