/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.ImmutableList;
import com.google.firebase.rules.lang.common.AbstractAstVisitor;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.Binding;
import com.google.firebase.rules.runtime.v1.BindingExpression;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LetBindingsInRulesV1
extends AbstractAstVisitor
implements SemanticValidator<TreeNode<Scope>> {
    private final ImmutableList.Builder<Issue> issues = ImmutableList.builder();

    @Override
    public List<Issue> check(TreeNode<Scope> node) {
        switch (node.getValue().ruleset().getVersion()) {
            case VERSION_2: {
                break;
            }
            case UNRECOGNIZED: 
            case VERSION_1: 
            case VERSION_UNSPECIFIED: {
                this.visitAst(node.getValue().ruleset());
            }
        }
        return this.issues.build();
    }

    @Override
    protected void visitBinding(BindingExpression expr) {
        for (Binding binding : expr.getBindingsList()) {
            this.issues.add((Object)CompilationIssueUtils.makeError(binding.getId().getSourcePosition(), (MessageReference)FirebaseRulesMessages.FORBIDDEN_LET_BINDING_V1, new String[0]));
        }
        super.visitBinding(expr);
    }
}

