/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.Lists;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MatchRuleMaxDepthValidator
implements SemanticValidator<TreeNode<Scope>> {
    private static final int MAX_ALLOWED_RESOURCE_RULE_DEPTH = 10;
    private final List<Issue> issues = Lists.newArrayList();

    @Override
    public List<Issue> check(TreeNode<Scope> node) {
        this.checkRecursive(node, 0);
        return this.issues;
    }

    private void checkRecursive(TreeNode<Scope> node, int depth) {
        if (depth > 12) {
            this.issues.add(CompilationIssueUtils.makeError(node.getValue().sourcePosition(), (MessageReference)FirebaseRulesMessages.ERROR_REACHED_MAX_ALLOWED_NESTED_RESOURCES, Long.toString(10L)));
            return;
        }
        for (TreeNode<Scope> child : node.getChildren()) {
            this.checkRecursive(child, depth + 1);
        }
    }
}

