/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.Lists;
import com.google.firebase.rules.lang.common.AbstractAstVisitor;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.lang.common.RegexValidator;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.CallExpression;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Literal;
import com.google.firebase.rules.tree.NodeVisitor;
import com.google.firebase.rules.tree.PreOrderTreeWalker;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.v1.SourcePosition;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RegexCheck
extends AbstractAstVisitor
implements SemanticValidator<TreeNode<Scope>>,
NodeVisitor<Scope> {
    private final List<Issue> issues = Lists.newArrayList();

    @Override
    public List<Issue> check(TreeNode<Scope> root) {
        new PreOrderTreeWalker<Scope>().walk(root, this);
        return this.issues;
    }

    @Override
    public void visit(TreeNode<Scope> node) {
        for (Expression exr : node.getValue().expressions()) {
            this.visit(exr);
        }
        for (Function function : node.getValue().functions()) {
            this.visit(function.getBody());
        }
    }

    @Override
    protected void visitCall(CallExpression callExpression) {
        Expression arg;
        String functionName;
        if (callExpression.hasOperand() && ((functionName = callExpression.getFunctionName().getName()).equals(FunctionTemplate.StringMembers.SPLIT.getFunctionName()) || functionName.equals(FunctionTemplate.StringMembers.MATCHES.getFunctionName()) || functionName.equals(FunctionTemplate.StringMembers.REPLACE.getFunctionName())) && callExpression.getArgumentsCount() == 1 && (arg = callExpression.getArguments(0)).getExpressionCase() == Expression.ExpressionCase.LITERAL && arg.getLiteral().getKindCase() == Literal.KindCase.STRING_VALUE) {
            String pattern = arg.getLiteral().getStringValue();
            this.validatePattern(arg.getSourcePosition(), pattern);
        }
        super.visitCall(callExpression);
    }

    private void validatePattern(SourcePosition sourcePosition, String pattern) {
        try {
            RegexValidator.validateAndCompile(pattern);
        }
        catch (IllegalArgumentException e) {
            this.issues.add(CompilationIssueUtils.makeError(sourcePosition, e));
        }
    }
}

