/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.lang.semantic;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.firebase.rules.lang.common.CompilationIssueUtils;
import com.google.firebase.rules.lang.semantic.Scope;
import com.google.firebase.rules.lang.semantic.SemanticValidator;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.tree.PreOrderTreeWalker;
import com.google.firebase.rules.tree.TreeNode;
import com.google.firebase.rules.v1.Issue;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import com.google.i18n.MessageReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class VariableRedefinitionValidator
implements SemanticValidator<TreeNode<Scope>> {
    @Override
    public List<Issue> check(TreeNode<Scope> root) {
        ArrayList<Issue> issues = Lists.newArrayList();
        new PreOrderTreeWalker<Scope>().walk(root, node -> {
            for (Function function : ((Scope)node.getValue()).functions()) {
                HashSet<String> variableNames = Sets.newHashSet();
                for (Identifier identifier : function.getParamsIdsList()) {
                    if (variableNames.contains(identifier.getName())) {
                        issues.add(CompilationIssueUtils.makeError(identifier, (MessageReference)FirebaseRulesMessages.ERROR_VARIABLE_IS_ALREADY_DEFINED, identifier.getName()));
                        continue;
                    }
                    variableNames.add(identifier.getName());
                }
            }
        });
        return issues;
    }
}

