/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.flogger.GoogleLogger;
import com.google.common.labs.stats.CacheStreamzExporter;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.rules.runtime.auth.CredentialsClient;
import com.google.firebase.rules.runtime.auth.GetCredentialsException;
import com.google.firebase.rules.runtime.auth.GetCredentialsRequest;
import com.google.firebase.rules.runtime.auth.ServiceAccountAuthenticator;
import com.google.gaia.mint.GaiaMintScopeCode;
import com.google.security.credentials.Authenticator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.Duration;

public class AuthenticatorCache
implements ServiceAccountAuthenticator {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/runtime/auth/AuthenticatorCache");
    private static final Duration MINT_DURATION = Duration.standardMinutes(5L);
    private static final long REFRESH_AFTER_NANOS = TimeUnit.MILLISECONDS.toNanos(MINT_DURATION.minus(Duration.standardSeconds(30L)).getMillis());
    private static final long EXPIRE_AFTER_NANOS = TimeUnit.MILLISECONDS.toNanos(MINT_DURATION.minus(Duration.standardSeconds(10L)).getMillis());
    private final LoadingCache<String, CacheValue> cache;
    private final ImmutableSet<Integer> acceptedScopeIds;

    private AuthenticatorCache(CredentialsClient credentialClient, Ticker ticker, @Nullable ListeningExecutorService executor, CacheBuilderSpec cacheSpec, ImmutableSet<GaiaMintScopeCode.ScopeCode> scopeIds, @Nullable String streamzPrefix) {
        Preconditions.checkArgument(!scopeIds.isEmpty());
        this.acceptedScopeIds = ImmutableSet.copyOf(Iterables.transform(scopeIds, GaiaMintScopeCode.ScopeCode::getValue));
        ServiceAccountAuthenticatorCacheLoader cacheLoader = new ServiceAccountAuthenticatorCacheLoader(Preconditions.checkNotNull(credentialClient), this.acceptedScopeIds, executor);
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.from(cacheSpec).expireAfterWrite(EXPIRE_AFTER_NANOS, TimeUnit.NANOSECONDS).refreshAfterWrite(REFRESH_AFTER_NANOS, TimeUnit.NANOSECONDS).ticker(ticker);
        if (!Strings.isNullOrEmpty(streamzPrefix)) {
            this.cache = cacheBuilder.recordStats().build(cacheLoader);
            CacheStreamzExporter.builder().build().export(streamzPrefix, this.cache);
        } else {
            this.cache = cacheBuilder.build(cacheLoader);
        }
    }

    @Override
    public ImmutableSet<Integer> acceptedScopeIds() {
        return this.acceptedScopeIds;
    }

    @Override
    public Authenticator getAuthenticator(String serviceAccountEmail) throws GetCredentialsException {
        try {
            CacheValue value = this.cache.get(serviceAccountEmail);
            return value.getAuthenticator();
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), GetCredentialsException.class);
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder().cacheSpec(CacheBuilderSpec.parse("maximumSize=1000,concurrencyLevel=10")).ticker(Ticker.systemTicker());
    }

    public static class Builder {
        private CredentialsClient credentialsClient;
        private Ticker ticker;
        private CacheBuilderSpec cacheSpec;
        private final ImmutableSet.Builder<GaiaMintScopeCode.ScopeCode> scopeCodes = ImmutableSet.builder();
        @Nullable
        private ListeningExecutorService executor;
        @Nullable
        private String streamzPrefix;

        private Builder() {
        }

        public Builder credentialsClient(CredentialsClient credentialsClient) {
            this.credentialsClient = credentialsClient;
            return this;
        }

        public Builder addScopeCode(GaiaMintScopeCode.ScopeCode scopeCode) {
            this.scopeCodes.add((Object)scopeCode);
            return this;
        }

        public Builder addAllScopeCodes(List<GaiaMintScopeCode.ScopeCode> scopeCodes) {
            this.scopeCodes.addAll(scopeCodes);
            return this;
        }

        public Builder ticker(Ticker ticker) {
            this.ticker = Preconditions.checkNotNull(ticker);
            return this;
        }

        public Builder cacheSpec(CacheBuilderSpec cacheSpec) {
            this.cacheSpec = Preconditions.checkNotNull(cacheSpec);
            return this;
        }

        public Builder executor(@Nullable ListeningExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder streamzPrefix(String streamzPrefix) {
            this.streamzPrefix = streamzPrefix;
            return this;
        }

        public AuthenticatorCache build() {
            ImmutableCollection scopeCodes = this.scopeCodes.build();
            Preconditions.checkState(!scopeCodes.isEmpty(), "At least one scope code must be added before calling build");
            return new AuthenticatorCache(this.credentialsClient, this.ticker, this.executor, this.cacheSpec, (ImmutableSet)scopeCodes, this.streamzPrefix);
        }
    }

    private static class ServiceAccountAuthenticatorCacheLoader
    extends CacheLoader<String, CacheValue> {
        private final CredentialsClient credentialClient;
        private final ImmutableSet<Integer> scopeIds;
        @Nullable
        private final ListeningExecutorService executor;

        public ServiceAccountAuthenticatorCacheLoader(CredentialsClient credentialClient, ImmutableSet<Integer> scopeIds, @Nullable ListeningExecutorService executor) {
            this.credentialClient = credentialClient;
            this.scopeIds = scopeIds;
            this.executor = executor;
        }

        @Override
        public CacheValue load(String accountEmail) throws GetCredentialsException {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/runtime/auth/AuthenticatorCache$ServiceAccountAuthenticatorCacheLoader", "load", 161, "AuthenticatorCache.java")).log("Getting short term credentials for %s", accountEmail);
            try {
                return new CacheValue((Authenticator)this.credentialClient.getCredentials(this.makeRequest(accountEmail)));
            }
            catch (GetCredentialsException e) {
                return ServiceAccountAuthenticatorCacheLoader.makeCacheValueForException(e);
            }
        }

        @Override
        public ListenableFuture<CacheValue> reload(String accountEmail, CacheValue oldValue) {
            if (this.executor == null) {
                return FluentFuture.from(this.credentialClient.getCredentialsAsync(this.makeRequest(accountEmail))).transform(CacheValue::new, MoreExecutors.directExecutor()).catchingAsync(GetCredentialsException.class, e -> Futures.immediateFuture(ServiceAccountAuthenticatorCacheLoader.makeCacheValueForException(e)), MoreExecutors.directExecutor());
            }
            return this.executor.submit(() -> this.load(accountEmail));
        }

        private static CacheValue makeCacheValueForException(GetCredentialsException e) throws GetCredentialsException {
            if (!e.isRetryable()) {
                return new CacheValue(e);
            }
            throw e;
        }

        private GetCredentialsRequest makeRequest(String accountEmail) {
            return GetCredentialsRequest.forServiceAccount(accountEmail).scopeIds(this.scopeIds).build();
        }
    }

    static class CacheValue {
        private final Authenticator authenticator;
        private final Exception exception;

        CacheValue(Authenticator authenticator) {
            this.authenticator = authenticator;
            this.exception = null;
        }

        CacheValue(Exception exception) {
            this.exception = exception;
            this.authenticator = null;
        }

        public Authenticator getAuthenticator() throws GetCredentialsException {
            if (this.exception != null) {
                Throwables.throwIfInstanceOf(this.exception, GetCredentialsException.class);
                throw new RuntimeException(this.exception);
            }
            return this.authenticator;
        }
    }
}

