/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.auth;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.rules.runtime.auth.CredentialsClient;
import com.google.firebase.rules.runtime.auth.GetCredentialsException;
import com.google.firebase.rules.runtime.auth.GetCredentialsRequest;
import com.google.gaia.mint.proto2api.MintWrapper;
import com.google.iam.credentials.v1.CloudGaia;
import com.google.iam.credentials.v1.GenerateMintRequest;
import com.google.net.rpc3.RpcException;
import com.google.net.rpc3.client.RpcClientContext;
import com.google.security.credentials.Authenticator;
import com.google.security.credentials.GaiaMint;
import java.util.concurrent.ExecutionException;

public class CloudGaiaCredentialsClient
implements CredentialsClient {
    private final CloudGaia.FutureInterface cloudGaiaClient;

    public CloudGaiaCredentialsClient(CloudGaia.FutureInterface cloudGaiaClient) {
        this.cloudGaiaClient = cloudGaiaClient;
    }

    @Override
    public GaiaMint getCredentials(GetCredentialsRequest request) throws GetCredentialsException {
        try {
            return (GaiaMint)this.getCredentialsAsync(request).get();
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf(e.getCause(), GetCredentialsException.class);
            throw new RuntimeException(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
    }

    @Override
    public ListenableFuture<GaiaMint> getCredentialsAsync(GetCredentialsRequest request) {
        return FluentFuture.from(this.cloudGaiaClient.generateMint(RpcClientContext.create(), GenerateMintRequest.newBuilder().setName(request.accountEmail()).addAllScopeId(request.scopeIds()).build())).transform(mintResponse -> Authenticator.fromGaiaMint((MintWrapper)mintResponse.getMintWrapper()), MoreExecutors.directExecutor()).catchingAsync(RpcException.class, e -> Futures.immediateFailedFuture(CloudGaiaCredentialsClient.makeCredsException(e)), MoreExecutors.directExecutor());
    }

    private static GetCredentialsException makeCredsException(RpcException e) {
        return new GetCredentialsException(e, e.getStatus().getCanonicalCode());
    }
}

