/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.common;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.Undefined;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import java.util.Locale;

public class EvaluationException
extends Exception {
    private final SourcePosition sourcePosition;

    public static EvaluationException makeUrlDecodeError(SourcePosition sourcePosition, String url, String errorDetails) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.URL_DECODE_ERROR.get(Locale.ENGLISH).toString(url, errorDetails));
    }

    public static EvaluationException makeUnboundVariableError(SourcePosition sourcePosition, String variableName) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.UNBOUND_VARIABLE_IN_PATH.get(Locale.ENGLISH).toString(variableName));
    }

    public static EvaluationException makeEmptyBindError(SourcePosition sourcePosition, String variableName) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.EMPTY_BIND.get(Locale.ENGLISH).toString(variableName));
    }

    public static EvaluationException makeUnknownBindError(SourcePosition sourcePosition, String variableName) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.UNKNOWN_BIND.get(Locale.ENGLISH).toString(variableName));
    }

    public static EvaluationException makeBindRedefinitionError(SourcePosition sourcePosition, String variableName) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.BIND_REDEFINITION.get(Locale.ENGLISH).toString(variableName));
    }

    public static EvaluationException makeInvalidIdentifierError(SourcePosition sourcePosition, String pathTemplate, String identifier) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.PATH_TEMPLATE_INVALID_IDENTIFIER.get(Locale.ENGLISH).toString(pathTemplate, identifier));
    }

    public static EvaluationException makeEmptyPathSegmentError(SourcePosition sourcePosition, String pathTemplate) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.PATH_TEMPLATE_EMPTY_SEGMENT.get(Locale.ENGLISH).toString(pathTemplate));
    }

    public static EvaluationException makeEmptyPathError(SourcePosition sourcePosition) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.PATH_TEMPLATE_EMPTY_PATH.get(Locale.ENGLISH).toString());
    }

    public static EvaluationException makeUnclosedCaptureError(SourcePosition sourcePosition, String pathTemplate) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.PATH_TEMPLATE_UNCLOSED_CAPTURE.get(Locale.ENGLISH).toString(pathTemplate));
    }

    public static EvaluationException makeAlreadyBoundError(SourcePosition sourcePosition, String variableName) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.REBIND_BIND.get(Locale.ENGLISH).toString(variableName));
    }

    public static EvaluationException makeUnsupportedOperationError(SourcePosition sourcePosition, String receivedSignature, String expectedSignatures) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.UNSUPPORTED_OPERATION_ERROR.get(Locale.ENGLISH).toString(receivedSignature, expectedSignatures));
    }

    public static EvaluationException makeIncorrectArgumentCountError(SourcePosition sourcePosition, int receivedCount, String expectedSignatures) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.INCORRECT_ARGUMENT_COUNT_ERROR.get(Locale.ENGLISH).toString(String.valueOf(receivedCount), expectedSignatures));
    }

    public static EvaluationException makeNullValueError(SourcePosition sourcePosition) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.NULL_VALUE_ERROR.get(Locale.ENGLISH).toString());
    }

    public static EvaluationException makeUndefinedPropertyError(SourcePosition sourcePosition, String property) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.UNDEFINED_PROPERTY_ERROR.get(Locale.ENGLISH).toString(property));
    }

    public static EvaluationException makeIndexOutOfBoundError(SourcePosition sourcePosition, long index, int size) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.INDEX_OUT_OF_BOUND_ERROR.get(Locale.ENGLISH).toString(Long.toString(index), Integer.toString(size)));
    }

    public static EvaluationException makeIllegalRangeError(SourcePosition sourcePosition, long fromIndex, long toIndex) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.ILLEGAL_RANGE_ERROR.get(Locale.ENGLISH).toString(Long.toString(fromIndex), Long.toString(toIndex)));
    }

    public static EvaluationException makeIntegerOverflowError(SourcePosition sourcePosition) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.INTEGER_OVERFLOW.get(Locale.ENGLISH).toString());
    }

    public static EvaluationException makeFunctionNotFoundError(SourcePosition sourcePosition, String functionName) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.FUNCTION_NOT_FOUND_ERROR.get(Locale.ENGLISH).toString(functionName));
    }

    public static EvaluationException makeTypeError(SourcePosition sourcePosition, ExpressionValue.KindCase findType, ExpressionValue.KindCase ... expectedTypes) {
        return EvaluationException.makeTypeError(sourcePosition, findType, ImmutableList.copyOf(expectedTypes));
    }

    public static EvaluationException makeTypeError(SourcePosition sourcePosition, ExpressionValue.KindCase findType, Iterable<ExpressionValue.KindCase> expectedTypes) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.TYPE_ERROR.get(Locale.ENGLISH).toString(KindCaseHelper.kindToString(findType), EvaluationException.expectedTypesToString(expectedTypes)));
    }

    private static String expectedTypesToString(Iterable<ExpressionValue.KindCase> expectedTypes) {
        String string = Joiner.on(",").join(Iterables.transform(expectedTypes, kindCase -> KindCaseHelper.kindToString(kindCase)));
        return new StringBuilder(2 + String.valueOf(string).length()).append("[").append(string).append("]").toString();
    }

    public static EvaluationException makeDivideByZeroError(SourcePosition sourcePosition) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.DIVIDE_BY_ZERO_ERROR.get(Locale.ENGLISH).toString());
    }

    public static EvaluationException makeServiceCallError(SourcePosition sourcePosition, String method, String argument, Throwable cause) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.SERVICE_CALL_ERROR.get(Locale.ENGLISH).toString(method, argument), cause);
    }

    public static EvaluationException makeVariableReadError(SourcePosition sourcePosition, String variable, Throwable cause) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.VARIABLE_READ_ERROR.get(Locale.ENGLISH).toString(variable), cause);
    }

    public static EvaluationException makeTypeConversionError(SourcePosition sourcePosition, ExpressionValue.KindCase from, ExpressionValue.KindCase to, Object value) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.TYPE_CONVERSION_ERROR.get(Locale.ENGLISH).toString(String.valueOf(value), KindCaseHelper.kindToString(from), KindCaseHelper.kindToString(to)));
    }

    public static EvaluationException makeUnknownDurationSuffixError(SourcePosition sourcePosition, String suffix) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.INVALID_REGEX_PATTERN.get(Locale.ENGLISH).toString(suffix));
    }

    public static EvaluationException makeInvalidLatLngError(SourcePosition sourcePosition, double lat, double lng) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.INVALID_LAT_LNG.get(Locale.ENGLISH).toString(Double.toString(lat), Double.toString(lng)));
    }

    public static EvaluationException makeInvalidDateExceptionError(SourcePosition sourcePosition, long year, long month, long day) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.INVALID_DATE.get(Locale.ENGLISH).toString(Long.toString(year), Long.toString(month), Long.toString(day)));
    }

    public static EvaluationException makeInvalidTimestampError(SourcePosition sourcePosition) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.INVALID_TIMESTAMP.get(Locale.ENGLISH).toString());
    }

    public static EvaluationException makeInvalidDurationError(SourcePosition sourcePosition) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.INVALID_DURATION.get(Locale.ENGLISH).toString());
    }

    public static EvaluationException makeBadYearTimestampError(SourcePosition sourcePosition, long year) {
        return new EvaluationException(sourcePosition, FirebaseRulesMessages.TIMESTAMP_OUT_OF_RANGE_BAD_YEAR.get(Locale.ENGLISH).toString(Long.toString(year)));
    }

    public EvaluationException(SourcePosition sourcePosition, String message) {
        this(sourcePosition, message, null);
    }

    public EvaluationException(SourcePosition sourcePosition, String message, Throwable cause) {
        super(Preconditions.checkNotNull(message), cause);
        this.sourcePosition = sourcePosition;
    }

    public SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public ExpressionValue toUndefinedValue() {
        return ExpressionValue.newBuilder().setUndefined(Undefined.newBuilder().setSourcePosition(this.getSourcePosition()).setCauseMessage(this.getMessage())).build();
    }
}

