/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.common.ExecutionContext;
import com.google.firebase.rules.runtime.common.FieldAccessVisitor;
import com.google.firebase.rules.runtime.common.ParentPointer;
import com.google.firebase.rules.runtime.v1.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class FieldAccessListener
implements EvaluationListener {
    private final Node pathRoot = new Node();

    public Set<List<String>> fieldAccesses() {
        return this.fieldAccesses(new ArrayList<String>(), this.pathRoot);
    }

    private Set<List<String>> fieldAccesses(List<String> qualifiedField, Node node) {
        if (node.accessCount > 0) {
            return ImmutableSet.of(qualifiedField);
        }
        ImmutableSet.Builder fields = ImmutableSet.builder();
        for (Map.Entry<String, Node> child : node.children.entrySet()) {
            CopyOnWriteArrayList<String> childField = Lists.newCopyOnWriteArrayList(qualifiedField);
            childField.add(child.getKey());
            fields.addAll(this.fieldAccesses(childField, child.getValue()));
        }
        return fields.build();
    }

    @Override
    public void beforeExpression(Expression expression, ParentPointer<ExecutionContext> contextParentPointer) {
        List<String> fieldAccess = FieldAccessVisitor.resolveFieldAccess(expression);
        if (!fieldAccess.isEmpty()) {
            Node path = this.pathRoot;
            for (String segment : fieldAccess) {
                if (path.accessCount > 0) {
                    --path.accessCount;
                }
                path.children.putIfAbsent(segment, new Node());
                path = (Node)path.children.get(segment);
            }
            ++path.accessCount;
        }
    }

    private static final class Node {
        final SortedMap<String, Node> children = new TreeMap<String, Node>();
        int accessCount;

        private Node() {
        }

        public String toString() {
            return String.format("accessCount=%d, childCount=%d", this.accessCount, this.children.size());
        }
    }
}

