/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.common;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public interface Method {
    public String id();

    public boolean appliesTo(String var1);

    public static enum StandardMethods implements Method
    {
        READ("read"),
        WRITE("write"),
        GET("get", READ),
        LIST("list", READ),
        CREATE("create", WRITE),
        UPDATE("update", WRITE),
        DELETE("delete", WRITE);

        @Nullable
        private final Method alias;
        private final String id;

        private StandardMethods(String id) {
            this(id, null);
        }

        private StandardMethods(String id, Method alias) {
            this.alias = alias;
            this.id = id;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public boolean appliesTo(String methodName) {
            return this.name().equals(Ascii.toUpperCase(methodName)) || this.alias != null && this.alias.appliesTo(methodName);
        }

        public static boolean ruleAppliesToMethod(String ruleMethodName, String methodName) {
            Preconditions.checkNotNull(ruleMethodName);
            Preconditions.checkNotNull(methodName);
            if (ruleMethodName.equals(methodName)) {
                return true;
            }
            try {
                StandardMethods method = StandardMethods.valueOf(Ascii.toUpperCase(methodName));
                return method.appliesTo(ruleMethodName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
    }
}

