/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.evaluators;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.StringUtil;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.firebear.client.JwtToken;
import com.google.firebase.rules.runtime.auth.RulesValidatedSecurityContext;
import com.google.firebase.rules.runtime.common.AsyncRuntimeFunction;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.common.EvaluationResult;
import com.google.firebase.rules.runtime.common.Evaluator;
import com.google.firebase.rules.runtime.common.Method;
import com.google.firebase.rules.runtime.evaluators.AutoValue_AuthRuleEvaluator_AuthRuleEvaluatorRequest;
import com.google.firebase.rules.runtime.evaluators.AutoValue_AuthRuleEvaluator_RuleContext;
import com.google.firebase.rules.runtime.evaluators.BaseEvaluatorRequest;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.PathUtils;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.utils.ResourceNameUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface AuthRuleEvaluator {
    public ListenableFuture<RuleResult> evaluate(RuleContext ... var1);

    public ListenableFuture<RuleResult> evaluate(List<RuleContext> var1);

    public String getRulesetName();

    public RulesetAst getRulesetAst();

    public static interface RuleResult
    extends EvaluationResult {
    }

    @AutoValue
    public static abstract class RuleContext
    implements Evaluator.Context {
        @Override
        public abstract String service();

        @Override
        public abstract String method();

        @Override
        public abstract ExpressionPathValue path();

        @Override
        public abstract ImmutableMap<String, Supplier<ListenableFuture<ExpressionValue>>> variables();

        @Override
        public abstract ImmutableMap<String, AsyncRuntimeFunction> functions();

        @Override
        public abstract ImmutableList<Supplier<EvaluationListener>> listeners();

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder().service(this.service()).method(this.method()).path(this.path()).variables(new HashMap<String, Supplier<ListenableFuture<ExpressionValue>>>(this.variables())).functions(this.functions().values()).listeners(this.listeners());
        }

        public static class Builder {
            private static final String TOKEN = "token";
            private static final String UID = "uid";
            private String service;
            private String method;
            private ExpressionPathValue path;
            private final Map<String, Supplier<ListenableFuture<ExpressionValue>>> variables = new HashMap<String, Supplier<ListenableFuture<ExpressionValue>>>();
            private final Map<String, AsyncRuntimeFunction> functions = new HashMap<String, AsyncRuntimeFunction>();
            private final List<Supplier<EvaluationListener>> listeners = new ArrayList<Supplier<EvaluationListener>>();

            public Builder service(String value) {
                this.service = value;
                return this;
            }

            public Builder get(String resourceName) {
                return this.method(Method.StandardMethods.GET.id()).path(resourceName);
            }

            public Builder list(String resourceName) {
                return this.method(Method.StandardMethods.LIST.id()).path(resourceName);
            }

            public Builder list(ExpressionPathValue pathValue) {
                return this.method(Method.StandardMethods.LIST.id()).path(pathValue);
            }

            public Builder create(String resourceName) {
                return this.method(Method.StandardMethods.CREATE.id()).path(resourceName);
            }

            public Builder update(String resourceName) {
                return this.method(Method.StandardMethods.UPDATE.id()).path(resourceName);
            }

            public Builder delete(String resourceName) {
                return this.method(Method.StandardMethods.DELETE.id()).path(resourceName);
            }

            public Builder method(String value) {
                this.method = Preconditions.checkNotNull(value);
                return this;
            }

            public Builder path(ExpressionPathValue pathValue) {
                this.path = pathValue;
                return this;
            }

            public Builder path(String value) {
                this.path(PathUtils.parse(value));
                return this;
            }

            public Builder variables(Map<String, Supplier<ListenableFuture<ExpressionValue>>> values) {
                Preconditions.checkNotNull(values);
                this.variables.clear();
                values.entrySet().forEach(entry -> this.supplyVariable((String)entry.getKey(), (Supplier)entry.getValue()));
                return this;
            }

            public Builder functions(Iterable<? extends AsyncRuntimeFunction> values) {
                Preconditions.checkNotNull(values);
                this.functions.clear();
                values.forEach(this::supplyFunction);
                return this;
            }

            public Builder listeners(Iterable<Supplier<EvaluationListener>> values) {
                Preconditions.checkNotNull(values);
                this.listeners.clear();
                values.forEach(value -> this.listeners.add((Supplier<EvaluationListener>)value));
                return this;
            }

            public Builder supplyVariable(String variableName, ExpressionValue value) {
                Preconditions.checkNotNull(value);
                return this.supplyVariable(variableName, Suppliers.ofInstance(Futures.immediateFuture(value)));
            }

            public Builder supplyVariable(String variableName, ListenableFuture<ExpressionValue> value) {
                Preconditions.checkNotNull(value);
                return this.supplyVariable(variableName, Suppliers.ofInstance(value));
            }

            public Builder supplyVariable(String variableName, Supplier<ListenableFuture<ExpressionValue>> value) {
                Preconditions.checkArgument(!StringUtil.isEmptyOrWhitespace(variableName));
                Preconditions.checkNotNull(value);
                this.variables.put(variableName, Suppliers.memoize(value::get));
                return this;
            }

            public Builder supplyFunction(AsyncRuntimeFunction value) {
                Preconditions.checkNotNull(value, "Supplied function cannot be null");
                Preconditions.checkNotNull(value.name(), "Supplied function name cannot be null");
                this.functions.put(value.name(), value);
                return this;
            }

            public ExpressionValue makeAuthField(RulesValidatedSecurityContext securityContext) {
                if (securityContext.validatedJwtToken() == null) {
                    return ExpressionValueUtils.NULL;
                }
                JwtToken token = securityContext.validatedJwtToken();
                ExpressionMapValue.Builder authBuilder = ExpressionMapValue.newBuilder();
                authBuilder.putFields(UID, ExpressionValueUtils.createValue((Object)token.getSubject()));
                authBuilder.putFields(TOKEN, ExpressionValueUtils.createValue(token.getPayload()));
                return ExpressionValue.newBuilder().setMapValue(authBuilder.build()).build();
            }

            public RuleContext build() {
                return new AutoValue_AuthRuleEvaluator_RuleContext(Preconditions.checkNotNull(this.service), Preconditions.checkNotNull(this.method), Preconditions.checkNotNull(this.path), ImmutableMap.copyOf(this.variables), ImmutableMap.copyOf(this.functions), ImmutableList.copyOf(this.listeners));
            }
        }
    }

    @AutoValue
    public static abstract class AuthRuleEvaluatorRequest
    extends BaseEvaluatorRequest {
        public static AuthRuleEvaluatorRequest release(String releaseName) {
            return new AutoValue_AuthRuleEvaluator_AuthRuleEvaluatorRequest(releaseName);
        }

        public static AuthRuleEvaluatorRequest release(String projectId, String releaseId) {
            return AuthRuleEvaluatorRequest.release(ResourceNameUtils.ReleaseReference.formatName(projectId, releaseId));
        }
    }
}

