/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.evaluators;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.eventflow.delivery.v1beta2.DeliveryProto;
import com.google.eventflow.eventsource.v1beta2.EventsourceFlowProto;
import com.google.events.v1.EventTrigger;
import com.google.firebase.eventflow.Trigger;
import com.google.firebase.rules.eventflow.client.path.Path;
import com.google.firebase.rules.eventflow.client.path.PathMatcher;
import com.google.firebase.rules.runtime.evaluators.AutoValue_EventRuleEvaluator_EventRuleContext;
import com.google.firebase.rules.runtime.evaluators.AutoValue_EventRuleEvaluator_EventRuleEvaluatorRequest;
import com.google.firebase.rules.runtime.evaluators.AutoValue_EventRuleEvaluator_EventRuleMatch;
import com.google.firebase.rules.runtime.evaluators.AutoValue_EventRuleEvaluator_Flow;
import com.google.firebase.rules.runtime.evaluators.BaseEvaluatorRequest;
import com.google.firebase.rules.utils.ResourceNameUtils;
import com.google.firebase.rules.v1.ReleaseExecutableVersion;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.joda.time.ReadableInstant;

public interface EventRuleEvaluator {
    public List<EventRuleMatch> evaluate(EventRuleContext var1);

    public Multimap<EventRuleContext, EventRuleMatch> evaluate(List<EventRuleContext> var1);

    public String getRulesetName();

    public boolean hasNoFlows();

    @AutoValue
    public static abstract class Flow {
        public abstract String getName();

        public abstract String getEventType();

        public abstract String getService();

        public abstract String getResource();

        public abstract EventsourceFlowProto.SignedToken getSignedToken();

        public abstract Trigger getTrigger();

        public abstract String getPubsubTopic();

        public abstract EventTrigger getEventTrigger();

        public abstract DeliveryProto.DeliveryToken getDeliveryToken();

        public static Flow fromV1Beta1API(com.google.firebase.eventflow.Flow v1Beta1Flow) {
            DeliveryProto.DeliveryToken token = v1Beta1Flow.getTransports().getEventflowDeliveryToken();
            if (token.getFlowName().isEmpty()) {
                token = DeliveryProto.DeliveryToken.newBuilder().setFlowName(v1Beta1Flow.getName()).setPubsubTopic(v1Beta1Flow.getPubsubTopic()).build();
            }
            String eventType = v1Beta1Flow.getEventTrigger().getEventType();
            String resource = v1Beta1Flow.getEventTrigger().getResource();
            if (eventType.isEmpty()) {
                eventType = v1Beta1Flow.getTrigger().getEventType();
                resource = v1Beta1Flow.getTrigger().getResource();
            }
            EventsourceFlowProto.SignedToken signedToken = EventsourceFlowProto.SignedToken.newBuilder().setVersion(EventsourceFlowProto.SignedToken.DataType.UNSIGNED_DELIVERY_TOKEN_V1).setData(token.toByteString()).build();
            return AutoValue_EventRuleEvaluator_Flow.builder().setName(v1Beta1Flow.getName()).setEventType(eventType).setService(v1Beta1Flow.getEventTrigger().getService()).setResource(resource).setSignedToken(signedToken).setTrigger(v1Beta1Flow.getTrigger()).setPubsubTopic(v1Beta1Flow.getPubsubTopic()).setEventTrigger(v1Beta1Flow.getEventTrigger()).setDeliveryToken(token).build();
        }

        public static List<Flow> fromV1Beta1API(List<com.google.firebase.eventflow.Flow> v1Beta1Flows) {
            return v1Beta1Flows.stream().map(Flow::fromV1Beta1API).collect(ImmutableList.toImmutableList());
        }

        public static Flow fromV1Beta2API(EventsourceFlowProto.Flow v1Beta2Flow) {
            return AutoValue_EventRuleEvaluator_Flow.builder().setName(v1Beta2Flow.getName()).setEventType(v1Beta2Flow.getTrigger().getEventType()).setService(v1Beta2Flow.getTrigger().getService()).setResource(v1Beta2Flow.getTrigger().getResource()).setSignedToken(v1Beta2Flow.getDeliveryToken()).build();
        }

        public static List<Flow> fromV1Beta2API(List<EventsourceFlowProto.Flow> v1Beta2Flows) {
            return v1Beta2Flows.stream().map(Flow::fromV1Beta2API).collect(ImmutableList.toImmutableList());
        }

        public static Builder builder() {
            return new AutoValue_EventRuleEvaluator_Flow.Builder().setSignedToken(EventsourceFlowProto.SignedToken.getDefaultInstance()).setTrigger(Trigger.getDefaultInstance()).setPubsubTopic("").setEventTrigger(EventTrigger.getDefaultInstance()).setDeliveryToken(DeliveryProto.DeliveryToken.getDefaultInstance());
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setName(String var1);

            public abstract Builder setEventType(String var1);

            public abstract Builder setService(String var1);

            public abstract Builder setResource(String var1);

            public abstract Builder setSignedToken(EventsourceFlowProto.SignedToken var1);

            public abstract Builder setTrigger(Trigger var1);

            public abstract Builder setPubsubTopic(String var1);

            public abstract Builder setEventTrigger(EventTrigger var1);

            public abstract Builder setDeliveryToken(DeliveryProto.DeliveryToken var1);

            public abstract Flow build();
        }
    }

    @AutoValue
    public static abstract class EventRuleMatch {
        public abstract Flow flow();

        public abstract PathMatcher.PathMatch pathMatch();

        @Deprecated
        public static EventRuleMatch create(com.google.firebase.eventflow.Flow v1Beta1Flow, PathMatcher.PathMatch pathMatch) {
            return new AutoValue_EventRuleEvaluator_EventRuleMatch(Flow.fromV1Beta1API(v1Beta1Flow), pathMatch);
        }

        public static EventRuleMatch create(Flow flow, PathMatcher.PathMatch pathMatch) {
            return new AutoValue_EventRuleEvaluator_EventRuleMatch(flow, pathMatch);
        }
    }

    @AutoValue
    public static abstract class EventRuleContext {
        public abstract Path resource();

        public abstract ImmutableList<String> eventTypes();

        public abstract String eventId();

        public abstract Optional<ReadableInstant> timestamp();

        public static EventRuleContext create(Path resource, String eventType) {
            return EventRuleContext.builder().setResource(resource).addEventType(eventType).build();
        }

        public static Builder builder() {
            return new AutoValue_EventRuleEvaluator_EventRuleContext.Builder().setEventId(UUID.randomUUID().toString());
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder {
            abstract ImmutableList.Builder<String> eventTypesBuilder();

            public Builder setResource(String resourcePath) {
                return this.setResource(resourcePath, Function.identity());
            }

            public Builder setResource(String resourcePath, Function<String, String> segmentDecoder) {
                return this.setResource(Path.parse(resourcePath, segmentDecoder));
            }

            public abstract Builder setResource(Path var1);

            public abstract Builder setEventTypes(List<String> var1);

            public Builder addEventType(String eventType) {
                this.eventTypesBuilder().add((Object)eventType);
                return this;
            }

            public abstract Builder setEventId(String var1);

            public abstract Builder setTimestamp(ReadableInstant var1);

            public abstract EventRuleContext build();
        }
    }

    @AutoValue
    public static abstract class EventRuleEvaluatorRequest
    extends BaseEvaluatorRequest {
        private static final ReleaseExecutableVersion DEFAULT_VERSION = ReleaseExecutableVersion.EVENT_FLOW_TRIGGERS_EXECUTABLE_V1;

        public abstract ReleaseExecutableVersion version();

        public abstract Function<String, String> pathSegmentDecoder();

        public static EventRuleEvaluatorRequest release(String projectId, String releaseId, Function<String, String> segmentDecoder) {
            return EventRuleEvaluatorRequest.release(ResourceNameUtils.ReleaseReference.formatName(projectId, releaseId), segmentDecoder);
        }

        public static EventRuleEvaluatorRequest release(String releaseName, Function<String, String> segmentDecoder) {
            return EventRuleEvaluatorRequest.release(releaseName, DEFAULT_VERSION, segmentDecoder);
        }

        public static EventRuleEvaluatorRequest release(String releaseName, ReleaseExecutableVersion version, Function<String, String> segmentDecoder) {
            switch (version) {
                case EVENT_FLOW_TRIGGERS_EXECUTABLE_V1: 
                case EVENT_FLOW_TRIGGERS_EXECUTABLE_V2: {
                    return new AutoValue_EventRuleEvaluator_EventRuleEvaluatorRequest(releaseName, version, segmentDecoder);
                }
                case RELEASE_EXECUTABLE_VERSION_UNSPECIFIED: 
                case FIREBASE_RULES_EXECUTABLE_V1: 
                case FIREBASE_RULES_EXECUTABLE_V2: {
                    throw new IllegalArgumentException("Unsupported executable version for EventRuleEvaluator");
                }
            }
            throw new IllegalArgumentException("Unrecognized version");
        }
    }
}

