/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.common.AsyncRuntimeFunction;
import com.google.firebase.rules.runtime.common.BaseFunction;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.Evaluator;
import com.google.firebase.rules.runtime.common.ExecutionContext;
import com.google.firebase.rules.runtime.common.FunctionProvider;
import com.google.firebase.rules.runtime.impl.Activation;
import com.google.firebase.rules.runtime.impl.AutoValue_ActivationImpl;
import com.google.firebase.rules.runtime.impl.BuiltinFunctions;
import com.google.firebase.rules.runtime.impl.CompositeFunctionProvider;
import com.google.firebase.rules.runtime.impl.ExecutableExpression;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.Function;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.MatchRuleOrBuilder;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.runtime.v1.ServiceRule;
import com.google.protobuf.MessageLiteOrBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class ActivationImpl
implements Activation {
    private FunctionProvider functionProvider;
    private ImmutableMap<String, Function> localFunctions;

    @Override
    @Nullable
    public abstract Activation parent();

    @Override
    public abstract ExecutionContext value();

    @Nullable
    private FunctionProvider functions() {
        return this.functionProvider;
    }

    private ActivationImpl functions(FunctionProvider provider) {
        this.functionProvider = provider;
        return this;
    }

    private ActivationImpl localFunctions(List<Function> localFunctions) {
        ImmutableMap.Builder<String, Function> functionBuilder = ImmutableMap.builder();
        for (Function function : localFunctions) {
            functionBuilder.put(function.getId().getName(), function);
        }
        this.localFunctions = functionBuilder.build();
        return this;
    }

    @Override
    @Nullable
    public BaseFunction getFunction(@Nullable ExpressionValue.KindCase kindCase, String functionName) {
        BaseFunction function;
        if (this.functions() != null && (function = this.functions().getFunction(kindCase, functionName)) != null) {
            return function;
        }
        if (this.parent() != null) {
            return this.parent().getFunction(kindCase, functionName);
        }
        return null;
    }

    @Override
    @Nullable
    public ExecutableExpression lookupLocalFunction(ExecutionRequest request) throws EvaluationException {
        for (ActivationImpl current = this; current != null; current = (ActivationImpl)current.parent()) {
            Function function;
            if (current.localFunctions == null || (function = current.localFunctions.get(request.getFunctionName())) == null) continue;
            if (function.getParamsIdsCount() != request.getArgumentsCount()) {
                throw EvaluationException.makeIncorrectArgumentCountError(request.getSourcePosition(), request.getArgumentsCount(), this.getParamNameSignature(function));
            }
            ImmutableMap.Builder<String, ExpressionValue> bindings = ImmutableMap.builder();
            for (int i = 0; i < function.getParamsIdsCount(); ++i) {
                ExpressionValue value = request.getArguments(i);
                bindings.put(function.getParamsIds(i).getName(), value);
            }
            return new ExecutableExpression(function.getBody(), current.makeNewScope(bindings.build()));
        }
        return null;
    }

    private String getParamNameSignature(Function function) {
        ArrayList paramIdNames = Lists.newArrayList();
        paramIdNames.addAll(function.getParamsIdsList().stream().map(Identifier::getName).collect(Collectors.toList()));
        return String.format("%s(%s)", function.getId().getName(), Joiner.on(", ").join(paramIdNames));
    }

    @Override
    @Nullable
    public ListenableFuture<ExpressionValue> getVariable(String variableName) {
        ImmutableMap<String, Supplier<ListenableFuture<ExpressionValue>>> variables;
        if (this.value() != null && (variables = this.value().variables()).containsKey(variableName)) {
            return variables.get(variableName).get();
        }
        if (this.parent() != null) {
            return this.parent().getVariable(variableName);
        }
        return null;
    }

    @Override
    public Activation makeChild(ExecutionContext executionContext) {
        ActivationImpl activation = new AutoValue_ActivationImpl.Builder().parent(this).value(executionContext).build();
        if (executionContext.scopeAstElement() instanceof MatchRuleOrBuilder) {
            activation.localFunctions(((MatchRuleOrBuilder)executionContext.scopeAstElement()).getFunctionsList());
        }
        return activation;
    }

    @Override
    public Activation makeNewScope(ImmutableMap<String, ExpressionValue> bindings) {
        MessageLiteOrBuilder astElement = this.value().scopeAstElement();
        ImmutableMap<String, Supplier<ListenableFuture<ExpressionValue>>> variables = ImmutableMap.copyOf(Maps.transformValues(bindings, v -> Suppliers.ofInstance(Futures.immediateFuture(v))));
        return new AutoValue_ActivationImpl.Builder().parent(this).value(ExecutionContext.builder().scopeAstElement(astElement).variables(variables).build()).build();
    }

    public static Activation requestActivation(Evaluator.Context context, RulesetAst rulesetAst, ServiceRule serviceRule) {
        ExecutionContext rootContext = ExecutionContext.builder().scopeAstElement(rulesetAst).variables(context.variables()).build();
        CompositeFunctionProvider functionProvider = new CompositeFunctionProvider(BuiltinFunctions.BUILTIN, new AsyncFunctionProvider(context.functions()));
        ActivationImpl rootActivation = new AutoValue_ActivationImpl.Builder().value(rootContext).build();
        rootActivation.functions(functionProvider).localFunctions(rulesetAst.getFunctionsList());
        ExecutionContext serviceContext = ExecutionContext.builder().scopeAstElement(serviceRule).variables(ImmutableMap.of()).build();
        ActivationImpl serviceActivation = (ActivationImpl)rootActivation.makeChild(serviceContext);
        serviceActivation.localFunctions(serviceRule.getFunctionsList());
        return serviceActivation;
    }

    private static class AsyncFunctionProvider
    implements FunctionProvider {
        private final ImmutableMap<String, ? extends AsyncRuntimeFunction> functions;

        private AsyncFunctionProvider(ImmutableMap<String, ? extends AsyncRuntimeFunction> functions) {
            this.functions = functions;
        }

        @Override
        @Nullable
        public AsyncRuntimeFunction getFunction(@Nullable ExpressionValue.KindCase kindCase, String functionName) {
            AsyncRuntimeFunction function = this.functions.get(functionName);
            if (function == null || !function.appliesToOperandKind(kindCase)) {
                return null;
            }
            return function;
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract Builder value(ExecutionContext var1);

        public abstract Builder parent(@Nullable Activation var1);

        public abstract ActivationImpl build();
    }
}

