/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.firebase.rules.runtime.common.BaseFunction;
import com.google.firebase.rules.runtime.common.FunctionProvider;
import com.google.firebase.rules.runtime.common.TypeProvider;
import com.google.firebase.rules.runtime.impl.functions.GlobalFunctions;
import com.google.firebase.rules.runtime.impl.types.BytesType;
import com.google.firebase.rules.runtime.impl.types.ConstraintType;
import com.google.firebase.rules.runtime.impl.types.DurationType;
import com.google.firebase.rules.runtime.impl.types.LatLngType;
import com.google.firebase.rules.runtime.impl.types.ListType;
import com.google.firebase.rules.runtime.impl.types.MapType;
import com.google.firebase.rules.runtime.impl.types.PathType;
import com.google.firebase.rules.runtime.impl.types.StringType;
import com.google.firebase.rules.runtime.impl.types.TimestampType;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.Map;

public class BuiltinFunctions
implements FunctionProvider {
    public static final FunctionProvider BUILTIN = BuiltinFunctions.newBuilder().register(new GlobalFunctions()).register(new StringType()).register(new BytesType()).register(new ListType()).register(new ConstraintType()).register(new PathType()).register(new MapType()).register(new DurationType()).register(new TimestampType()).register(new LatLngType()).build();
    private final FunctionProvider globalFunctions;
    private final ImmutableMap<ExpressionValue.KindCase, FunctionProvider> typeFunctionMap;

    public BuiltinFunctions(FunctionProvider globalFunctions, Map<ExpressionValue.KindCase, FunctionProvider> typeFunctionMap) {
        this.globalFunctions = globalFunctions;
        this.typeFunctionMap = ImmutableMap.copyOf(typeFunctionMap);
    }

    @Override
    public BaseFunction getFunction(ExpressionValue.KindCase operandType, String functionName) {
        if (operandType == null) {
            return this.globalFunctions.getFunction(null, functionName);
        }
        FunctionProvider typeFunctions = this.typeFunctionMap.get(operandType);
        return typeFunctions != null ? typeFunctions.getFunction(operandType, functionName) : null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private FunctionProvider globalFunctions;
        private final Map<ExpressionValue.KindCase, FunctionProvider> typeFunctionMap = Maps.newHashMap();

        public Builder register(FunctionProvider globalFunctions) {
            Preconditions.checkState(globalFunctions != null, "Global functions may not be provided more than once.");
            this.globalFunctions = globalFunctions;
            return this;
        }

        public Builder register(TypeProvider typeProvider) {
            ExpressionValue.KindCase operandType = typeProvider.operandType();
            Preconditions.checkState(!this.typeFunctionMap.containsKey(operandType), "Type %s already defined", (Object)operandType.name());
            this.typeFunctionMap.put(operandType, typeProvider);
            return this;
        }

        public BuiltinFunctions build() {
            return new BuiltinFunctions(this.globalFunctions, this.typeFunctionMap);
        }
    }
}

