/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.rules.lang.common.SourcePositionUtils;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.common.EvaluationRestrictions;
import com.google.firebase.rules.runtime.common.EvaluationResult;
import com.google.firebase.rules.runtime.common.Evaluator;
import com.google.firebase.rules.runtime.common.ExecutionContext;
import com.google.firebase.rules.runtime.common.Method;
import com.google.firebase.rules.runtime.impl.Activation;
import com.google.firebase.rules.runtime.impl.ActivationImpl;
import com.google.firebase.rules.runtime.impl.CompositeListener;
import com.google.firebase.rules.runtime.impl.EvaluationManager;
import com.google.firebase.rules.runtime.impl.ExecutableExpression;
import com.google.firebase.rules.runtime.impl.ExpressionStackWalker;
import com.google.firebase.rules.runtime.impl.FineLoggingListener;
import com.google.firebase.rules.runtime.impl.Interpreter;
import com.google.firebase.rules.runtime.impl.PathMatcher;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.MatchRuleOrBuilder;
import com.google.firebase.rules.runtime.v1.Permission;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import com.google.firebase.rules.runtime.v1.RulesetAstOrBuilder;
import com.google.firebase.rules.runtime.v1.ServiceRule;
import com.google.firebase.rules.runtime.v1.ServiceRuleOrBuilder;
import com.google.firebase.rules.utils.FutureUtils;
import com.google.firebase.rules.v1.SourcePosition;
import com.google.firebase.rules.validations.FirebaseRulesMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class DefaultEvaluator
implements Evaluator {
    public static final EvaluationResult TRUE_RESULT = () -> true;
    public static final EvaluationResult FALSE_RESULT = () -> false;
    private final RulesetAst ruleset;
    private final ImmutableList<Supplier<EvaluationListener>> listeners;
    private final EvaluationRestrictions evaluationRestriction;
    private final ExpressionStackWalker expressionStackWalker;

    public DefaultEvaluator(RulesetAst ruleset) {
        this(ruleset, ImmutableList.of(), EvaluationRestrictions.builder().build());
    }

    public DefaultEvaluator(RulesetAst ruleset, ImmutableList<Supplier<EvaluationListener>> listeners, EvaluationRestrictions evaluationRestrictions) {
        this.ruleset = ruleset;
        this.listeners = listeners;
        this.evaluationRestriction = evaluationRestrictions;
        this.expressionStackWalker = new ExpressionStackWalker();
    }

    @Override
    public ListenableFuture<EvaluationResult> evaluate(Evaluator.Context request) {
        return this.evaluate(ImmutableList.of(request));
    }

    @Override
    public ListenableFuture<EvaluationResult> evaluate(final ImmutableList<? extends Evaluator.Context> contexts) {
        ImmutableList.Builder futures = ImmutableList.builder();
        EvaluationManager evaluationManager = this.makeEvaluationManager();
        final EvaluationListener evaluationListener = this.makeEvaluationListener();
        evaluationListener.beforePermissionEvaluation(contexts);
        Interpreter interpreter = Interpreter.iterative(evaluationManager);
        for (final Evaluator.Context context : contexts) {
            ServiceRule serviceRule = this.getServiceRule(context.service());
            if (serviceRule == null) {
                futures.add(Futures.immediateFuture(false));
                break;
            }
            Activation requestActivation = ActivationImpl.requestActivation(context, this.ruleset, serviceRule);
            Preconditions.checkArgument(((ExecutionContext)requestActivation.value()).scopeAstElement() instanceof ServiceRuleOrBuilder);
            List<MatchRule> matchRules = ((ServiceRuleOrBuilder)((ExecutionContext)requestActivation.value()).scopeAstElement()).getMatchRulesList();
            List<Activation> matchedActivations = PathMatcher.matchRules(context.path(), matchRules, requestActivation, this.ruleset.getVersion());
            ImmutableList.Builder allowValues = ImmutableList.builder();
            ImmutableCollection scopedListenerSet = ImmutableList.of();
            if (!context.listeners().isEmpty()) {
                ImmutableList.Builder scopedListenerBuilder = ImmutableList.builder();
                scopedListenerSet = ((ImmutableList.Builder)((ImmutableList.Builder)scopedListenerBuilder.addAll(context.listeners())).add(() -> evaluationListener)).build();
            }
            block1: for (Activation activation : matchedActivations) {
                for (final Expression allowRule : DefaultEvaluator.findRules(activation, context.method())) {
                    final EvaluationListener scopedEvaluationListener = scopedListenerSet.isEmpty() ? evaluationListener : this.makeEvaluationListener(scopedListenerSet);
                    ListenableFuture<Boolean> asyncAllowValue = interpreter.interpret(new ExecutableExpression(allowRule, activation), scopedEvaluationListener);
                    allowValues.add(asyncAllowValue);
                    Futures.addCallback(asyncAllowValue, new FutureCallback<Boolean>(this){

                        @Override
                        public void onSuccess(@Nullable Boolean allow) {
                            scopedEvaluationListener.afterSinglePermissionEvaluation(context, allow, allowRule);
                        }

                        @Override
                        public void onFailure(Throwable throwable) {
                            scopedEvaluationListener.afterSinglePermissionEvaluation(context, throwable, allowRule);
                        }
                    }, MoreExecutors.directExecutor());
                    if (!FutureUtils.isTrueOrCancelled(asyncAllowValue)) continue;
                    continue block1;
                }
            }
            ListenableFuture<Boolean> asyncRequestValue = FutureUtils.ternaryOr((ImmutableList<ListenableFuture<Boolean>>)allowValues.build());
            futures.add(asyncRequestValue);
            if (!FutureUtils.isFalseOrErrorOrCancelled(asyncRequestValue)) continue;
            break;
        }
        ListenableFuture<Boolean> response = FutureUtils.ternaryAnd((ImmutableList<ListenableFuture<Boolean>>)futures.build());
        Futures.addCallback(response, new FutureCallback<Boolean>(this){

            @Override
            public void onSuccess(Boolean allow) {
                evaluationListener.afterPermissionEvaluation((ImmutableList<? extends Evaluator.Context>)contexts, allow);
            }

            @Override
            public void onFailure(Throwable throwable) {
                evaluationListener.afterPermissionEvaluation((ImmutableList<? extends Evaluator.Context>)contexts, throwable);
            }
        }, MoreExecutors.directExecutor());
        ListenableFuture<EvaluationResult> listenableFuture = Futures.catchingAsync(Futures.transform(response, permitted -> permitted != false ? TRUE_RESULT : FALSE_RESULT, MoreExecutors.directExecutor()), EvaluationException.class, new TransformEvaluationException(this.ruleset), MoreExecutors.directExecutor());
        return FutureUtils.cloneFuture(listenableFuture);
    }

    @Nullable
    private ServiceRule getServiceRule(String serviceName) {
        for (ServiceRule serviceRule : this.ruleset.getServiceRulesList()) {
            if (!serviceName.equals(serviceRule.getServiceName().getName())) continue;
            return serviceRule;
        }
        return null;
    }

    private static List<Expression> findRules(Activation activation, String contextOperation) {
        Preconditions.checkArgument(((ExecutionContext)activation.value()).scopeAstElement() instanceof MatchRuleOrBuilder);
        ArrayList<Expression> matches = Lists.newArrayList();
        MatchRuleOrBuilder matchRule = (MatchRuleOrBuilder)((ExecutionContext)activation.value()).scopeAstElement();
        for (Permission rule : matchRule.getPermissionsList()) {
            if (!DefaultEvaluator.ruleMatchesOperation(rule, contextOperation)) continue;
            matches.add(rule.getAllow());
        }
        return matches;
    }

    private static boolean ruleMatchesOperation(Permission rule, String contextOperation) {
        for (Identifier ruleOperationId : rule.getIdsList()) {
            String ruleOperation = ruleOperationId.getName();
            if (!Method.StandardMethods.ruleAppliesToMethod(ruleOperation, contextOperation)) continue;
            return true;
        }
        return false;
    }

    private EvaluationManager makeEvaluationManager() {
        return new EvaluationManager(this.evaluationRestriction, this.expressionStackWalker);
    }

    private EvaluationListener makeEvaluationListener() {
        ImmutableCollection listenerSet = this.listeners;
        if (((GoogleLogger.Api)FineLoggingListener.logger.atFine()).isEnabled()) {
            ImmutableList.Builder listenersWithLogging = ImmutableList.builder();
            listenersWithLogging.addAll(this.listeners);
            listenersWithLogging.add(Suppliers.ofInstance(new FineLoggingListener()));
            listenerSet = listenersWithLogging.build();
        }
        return this.makeEvaluationListener(listenerSet);
    }

    private EvaluationListener makeEvaluationListener(Collection<Supplier<EvaluationListener>> listeners) {
        if (listeners.size() == 1) {
            return Iterables.getOnlyElement(listeners).get();
        }
        CompositeListener.Builder builder = CompositeListener.builder();
        for (Supplier<EvaluationListener> supplier : listeners) {
            builder.addListener(supplier.get());
        }
        return builder.build();
    }

    private static String getFullMessage(SourcePosition sourcePosition, String message) {
        return FirebaseRulesMessages.EVALUATION_ERROR_MESSAGE.get(Locale.ENGLISH).toString(sourcePosition.getFileName(), Integer.toString(sourcePosition.getLine()), Integer.toString(sourcePosition.getColumn()), message);
    }

    private static class TransformEvaluationException
    implements AsyncFunction<EvaluationException, EvaluationResult> {
        private final RulesetAstOrBuilder ruleset;

        private TransformEvaluationException(RulesetAstOrBuilder ruleset) {
            this.ruleset = ruleset;
        }

        @Override
        public ListenableFuture<EvaluationResult> apply(EvaluationException e) throws Exception {
            SourcePosition sourcePosition = SourcePositionUtils.fillFileName(e.getSourcePosition(), this.ruleset.getFileMetadataList());
            String message = DefaultEvaluator.getFullMessage(sourcePosition, e.getMessage());
            throw new EvaluationException(sourcePosition, message, e.getCause());
        }
    }
}

