/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.v1.Binding;
import com.google.firebase.rules.runtime.v1.CallExpression;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.Literal;
import com.google.firebase.rules.runtime.v1.MapExpression;
import com.google.firebase.rules.runtime.v1.Member;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.v1.SourcePosition;
import java.util.IdentityHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExpressionStackWalker {
    private static final int BRANCH_ARGUMENT_COUNT = 2;
    @GuardedBy(value="lock")
    private final IdentityHashMap<Expression, ImmutableList<Expression>> cache = new IdentityHashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<Expression> walk(Expression expression) {
        this.lock.readLock().lock();
        try {
            ImmutableList<Expression> result = this.cache.get(expression);
            if (result == null) {
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    result = this.cache.get(expression);
                    if (result == null) {
                        result = this.doWalk(expression);
                        this.cache.put(expression, result);
                    }
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            ImmutableList<Expression> immutableList = result;
            return immutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void walk(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        switch (expression.getExpressionCase()) {
            case LITERAL: {
                expressionStack.add((Object)expression);
                break;
            }
            case MEMBER: {
                this.walkMember(expression, expressionStack);
                break;
            }
            case LIST: {
                this.walkList(expression, expressionStack);
                break;
            }
            case PATH: {
                this.walkPath(expression, expressionStack);
                break;
            }
            case MAP: {
                this.walkMap(expression, expressionStack);
                break;
            }
            case CALL: {
                this.walkCall(expression, expressionStack);
                break;
            }
            case BINDING: {
                this.walkBinding(expression, expressionStack);
                break;
            }
            case EXPRESSION_NOT_SET: {
                String string = String.valueOf(expression.getSourcePosition());
                throw new RuntimeException(new StringBuilder(29 + String.valueOf(string).length()).append("Cannot find expression type: ").append(string).toString());
            }
        }
    }

    private ImmutableList<Expression> doWalk(Expression expression) {
        ImmutableList.Builder<Expression> builder = ImmutableList.builder();
        this.walk(expression, builder);
        return builder.build();
    }

    private void walkMember(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        Member member = expression.getMember();
        if (member.hasOperand()) {
            this.walk(member.getOperand(), expressionStack);
        }
        expressionStack.add((Object)expression);
    }

    private void walkCall(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        CallExpression call = expression.getCall();
        String functionName = call.getFunctionName().getName();
        if (FunctionTemplate.BuiltInBooleanOperator.isShortCircuit(functionName)) {
            this.walkShortCircuit(expression, expressionStack);
        } else {
            this.walkFunction(expression, expressionStack);
        }
    }

    private void walkShortCircuit(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        CallExpression branchCall = expression.getCall();
        Identifier functionId = branchCall.getFunctionName();
        boolean jumpIfValue = false;
        if (functionId.getName().equals(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_OR.getFunctionName())) {
            jumpIfValue = true;
        }
        int argumentCount = branchCall.getArgumentsCount();
        SourcePosition sourcePosition = functionId.getSourcePosition();
        if (argumentCount != 2) {
            String string = String.valueOf(functionId);
            throw new RuntimeException(new StringBuilder(29 + String.valueOf(string).length()).append("The operator should be binary").append(string).toString());
        }
        ImmutableList<Expression> lhsBranchStack = this.walk(branchCall.getArguments(0));
        ImmutableList<Expression> rhsBranchStack = this.walk(branchCall.getArguments(1));
        Expression jumpIf = Expression.newBuilder().setCall(CallExpression.newBuilder().setFunctionName(Identifier.newBuilder().setName(FunctionTemplate.BuiltInBooleanOperator.JUMP_IF.getFunctionName()).setSourcePosition(sourcePosition)).addArguments(Expression.newBuilder().setLiteral(Literal.newBuilder().setBoolValue(jumpIfValue)).setSourcePosition(sourcePosition)).addArguments(Expression.newBuilder().setLiteral(Literal.newBuilder().setLongValue(rhsBranchStack.size() + 1)).setSourcePosition(sourcePosition))).setSourcePosition(sourcePosition).build();
        expressionStack.addAll(lhsBranchStack);
        expressionStack.add((Object)jumpIf);
        expressionStack.addAll(rhsBranchStack);
        expressionStack.add((Object)expression);
    }

    private void walkFunction(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        CallExpression call = expression.getCall();
        for (Expression argument : Lists.reverse(call.getArgumentsList())) {
            this.walk(argument, expressionStack);
        }
        if (call.hasOperand()) {
            this.walk(call.getOperand(), expressionStack);
        }
        expressionStack.add((Object)expression);
    }

    private void walkBinding(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        for (Binding b : Lists.reverse(expression.getBinding().getBindingsList())) {
            this.walk(b.getBody(), expressionStack);
        }
        expressionStack.add((Object)expression);
    }

    private void walkList(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        for (Expression element : Lists.reverse(expression.getList().getExpressionsList())) {
            this.walk(element, expressionStack);
        }
        expressionStack.add((Object)expression);
    }

    private void walkPath(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        Lists.reverse(expression.getPath().getSegmentsList()).stream().filter(segment -> segment.getKindCase() == Path.PathSegment.KindCase.EXPRESSION).forEach(segment -> this.walk(segment.getExpression(), expressionStack));
        expressionStack.add((Object)expression);
    }

    private void walkMap(Expression expression, ImmutableList.Builder<Expression> expressionStack) {
        MapExpression map = expression.getMap();
        for (int i = map.getKeysCount() - 1; i >= 0; --i) {
            this.walk(map.getValues(i), expressionStack);
            this.walk(map.getKeys(i), expressionStack);
        }
        expressionStack.add((Object)expression);
    }
}

