/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.StackSize;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.common.Evaluator;
import com.google.firebase.rules.runtime.common.ExecutionContext;
import com.google.firebase.rules.runtime.common.ParentPointer;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class FineLoggingListener
implements EvaluationListener {
    static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/runtime/impl/FineLoggingListener");
    private static final Joiner NEW_LINE_JOINER = Joiner.on('\n');
    private static final Joiner.MapJoiner MAP_JOINER = Joiner.on(',').withKeyValueSeparator(':');
    private static final Joiner COMMA_JOINER = Joiner.on(',');

    @Override
    public void beforeExpression(Expression expression, ParentPointer<ExecutionContext> contextParentPointer) {
        if (((GoogleLogger.Api)logger.atFiner()).isEnabled()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withInjectedLogSite("com/google/firebase/rules/runtime/impl/FineLoggingListener", "beforeExpression", 47, "FineLoggingListener.java")).log("[%d:%d] Executing expression. Scope=[%s].", expression.getSourcePosition().getLine(), expression.getSourcePosition().getColumn(), this.variables(contextParentPointer));
        }
    }

    @Override
    public void afterExpression(Expression expression, ParentPointer<ExecutionContext> contextParentPointer, @Nullable ExpressionValue expressionValue) {
        if (((GoogleLogger.Api)logger.atFiner()).isEnabled()) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withInjectedLogSite("com/google/firebase/rules/runtime/impl/FineLoggingListener", "afterExpression", 61, "FineLoggingListener.java")).log("[%d:%d] Expression evaluation done. Result=[%s].", expression.getSourcePosition().getLine(), expression.getSourcePosition().getColumn(), expressionValue);
        }
    }

    @Override
    public void beforeAsyncFunction(long uniqueId, ExecutionRequest request, ParentPointer<ExecutionContext> contextParentPointer) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/runtime/impl/FineLoggingListener", "beforeAsyncFunction", 74, "FineLoggingListener.java")).log("[%d:%d] Executing function [%s]. Arguments=[%s], Scope=[%s].", request.getSourcePosition().getLine(), request.getSourcePosition().getColumn(), request.getFunctionName(), COMMA_JOINER.join(request.getArgumentsList()), contextParentPointer);
    }

    @Override
    public void afterAsyncFunction(long uniqueId, final ExecutionRequest request, ParentPointer<ExecutionContext> contextParentPointer, ListenableFuture<ExecutionResponse> asyncResponse) {
        Futures.addCallback(asyncResponse, new FutureCallback<ExecutionResponse>(this){

            @Override
            public void onSuccess(@Nullable ExecutionResponse v) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/runtime/impl/FineLoggingListener$1", "onSuccess", 94, "FineLoggingListener.java")).log("[%d:%d] Function execution completed. Response=[%s].", request.getSourcePosition().getLine(), request.getSourcePosition().getColumn(), v);
            }

            @Override
            public void onFailure(Throwable throwable) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(throwable)).withStackTrace(StackSize.FULL)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/FineLoggingListener$1", "onFailure", 101, "FineLoggingListener.java")).log("[%d:%d] Function execution failed.", request.getSourcePosition().getLine(), request.getSourcePosition().getColumn());
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public void beforePermissionEvaluation(ImmutableList<? extends Evaluator.Context> contexts) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/runtime/impl/FineLoggingListener", "beforePermissionEvaluation", 111, "FineLoggingListener.java")).log("Evaluating the rules. context=[%s]", NEW_LINE_JOINER.join(contexts));
    }

    @Override
    public void afterPermissionEvaluation(ImmutableList<? extends Evaluator.Context> contexts, boolean allow) {
        ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withInjectedLogSite("com/google/firebase/rules/runtime/impl/FineLoggingListener", "afterPermissionEvaluation", 116, "FineLoggingListener.java")).log("Evaluation of the rules done. allow=[%s]", allow);
    }

    @Override
    public void afterPermissionEvaluation(ImmutableList<? extends Evaluator.Context> contexts, Throwable throwable) {
        ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause(throwable)).withStackTrace(StackSize.FULL)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/FineLoggingListener", "afterPermissionEvaluation", 122, "FineLoggingListener.java")).log("Evaluation of the rules failed.");
    }

    private String variables(ParentPointer<ExecutionContext> scope) {
        HashMap<String, Supplier<ListenableFuture<ExpressionValue>>> variables = Maps.newHashMap();
        while (scope != null) {
            if (scope.value() != null) {
                variables.putAll(scope.value().variables());
            }
            scope = scope.parent();
        }
        return MAP_JOINER.join(variables);
    }
}

