/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.flogger.GoogleLogger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;

class MultiThreadedCpuTimeMeasurer {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/runtime/impl/MultiThreadedCpuTimeMeasurer");
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final Duration RESOLUTION = Duration.ofMillis(500L);
    private Duration lastTotalTime;
    private long lastTotalTimeCalculated = 0L;
    @GuardedBy(value="lock")
    private final Map<Long, Stopwatch> stopwatchMap = new HashMap<Long, Stopwatch>();
    private final Supplier<Ticker> tickerFactory;
    private final Ticker resolutionTicker;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    MultiThreadedCpuTimeMeasurer() {
        this(THREAD_MX_BEAN.isThreadCpuTimeSupported() && THREAD_MX_BEAN.isThreadCpuTimeEnabled() ? ThreadCpuTicker::forCurrentThread : Ticker::systemTicker, Ticker.systemTicker());
    }

    @VisibleForTesting
    MultiThreadedCpuTimeMeasurer(Supplier<Ticker> tickerFactory, Ticker resolutionTicker) {
        this.tickerFactory = tickerFactory;
        this.resolutionTicker = resolutionTicker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        this.lock.writeLock().lock();
        try {
            long tid = Thread.currentThread().getId();
            Stopwatch stopwatch = this.stopwatchMap.get(tid);
            if (stopwatch == null) {
                stopwatch = this.createStartedStopwatch();
            } else {
                stopwatch.start();
            }
            this.stopwatchMap.put(tid, stopwatch);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void stop() {
        this.lock.writeLock().lock();
        try {
            this.stopwatchMap.get(Thread.currentThread().getId()).stop();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Duration totalTime() {
        this.lock.readLock().lock();
        try {
            long now = this.resolutionTicker.read();
            if (this.lastTotalTimeCalculated + RESOLUTION.toNanos() >= now) {
                Duration duration = this.lastTotalTime;
                return duration;
            }
            long totalTime = 0L;
            Object object = this;
            synchronized (object) {
                for (Map.Entry<Long, Stopwatch> entry : this.stopwatchMap.entrySet()) {
                    totalTime += entry.getValue().elapsed().toNanos();
                }
            }
            this.lastTotalTimeCalculated = now;
            this.lastTotalTime = Duration.ofNanos(totalTime);
            object = this.lastTotalTime;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Stopwatch createStartedStopwatch() {
        return Stopwatch.createStarted(this.tickerFactory.get());
    }

    static {
        try {
            THREAD_MX_BEAN.setThreadCpuTimeEnabled(true);
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/MultiThreadedCpuTimeMeasurer", "<clinit>", 56, "MultiThreadedCpuTimeMeasurer.java")).log("Unable to enable the cpu time measurement. Rules will use system time to limit the execution time.");
        }
    }

    private static class ThreadCpuTicker
    extends Ticker {
        private final long threadId;

        private ThreadCpuTicker(long threadId) {
            this.threadId = threadId;
        }

        @Override
        public long read() {
            return THREAD_MX_BEAN.getThreadCpuTime(this.threadId);
        }

        static Ticker forCurrentThread() {
            return new ThreadCpuTicker(Thread.currentThread().getId());
        }
    }
}

