/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.base.Pair;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.firebase.rules.runtime.common.ExecutionContext;
import com.google.firebase.rules.runtime.common.ParentPointer;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.ListView;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionPathSegmentValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.Literal;
import com.google.firebase.rules.runtime.v1.MatchRule;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.runtime.v1.RulesetAst;
import java.util.AbstractCollection;
import java.util.List;
import java.util.function.Consumer;

public class PathMatcher {
    private PathMatcher() {
    }

    public static <T extends ParentPointer<ExecutionContext>> List<T> matchRules(ExpressionPathValue pathValue, List<MatchRule> rules, T parentNode, RulesetAst.Version version) {
        Preconditions.checkArgument(version != RulesetAst.Version.UNRECOGNIZED, "unknown rules version");
        ImmutableList.Builder collector = ImmutableList.builder();
        ListView<ExpressionPathSegmentValue> segments = ListView.of(pathValue.getSegmentsList());
        PathMatcher.matchRules(segments, rules, parentNode, collector::add, version, false);
        return collector.build();
    }

    private static <T extends ParentPointer<ExecutionContext>> void matchRules(ListView<ExpressionPathSegmentValue> resourcePath, List<MatchRule> rules, T parentNode, Consumer<T> collector, RulesetAst.Version version, boolean globAlreadyMatched) {
        for (MatchRule rule : rules) {
            PathMatcher.matchRules(resourcePath, parentNode, collector, rule, version, globAlreadyMatched);
        }
    }

    private static <T extends ParentPointer<ExecutionContext>> void matchRules(ListView<ExpressionPathSegmentValue> resourcePath, T parentNode, Consumer<T> collector, MatchRule rule, RulesetAst.Version version, boolean globAlreadyMatched) {
        Path rulePath = rule.getPath();
        if (PathMatcher.canShortCircuitMatching(resourcePath.size(), rulePath.getSegmentsCount(), version)) {
            return;
        }
        ImmutableMap.Builder<String, Supplier<ListenableFuture<ExpressionValue>>> variables = ImmutableMap.builder();
        List<Path.PathSegment> ruleSegments = rulePath.getSegmentsList();
        block15: for (int i = 0; i < ruleSegments.size(); ++i) {
            Path.PathSegment ruleSegment = ruleSegments.get(i);
            switch (ruleSegment.getKindCase()) {
                case GLOB_CAPTURE: {
                    Object splitPath;
                    String variableName;
                    switch (version) {
                        case VERSION_UNSPECIFIED: 
                        case VERSION_1: {
                            variableName = ruleSegment.getGlobCapture().getName();
                            if (resourcePath.isEmpty()) {
                                return;
                            }
                            Preconditions.checkArgument(i == ruleSegments.size() - 1);
                            splitPath = resourcePath.splitAt(s -> s.getKindCase() != ExpressionPathSegmentValue.KindCase.SIMPLE);
                            if (((ListView)((Pair)splitPath).first).size() == resourcePath.size()) {
                                ExpressionValue value = ExpressionValueUtils.createValue(ExpressionPathValue.newBuilder().addAllSegments(resourcePath).build());
                                variables.put(variableName, Suppliers.ofInstance(Futures.immediateFuture(value)));
                            }
                            resourcePath = ((ListView)((Pair)splitPath).second).isEmpty() ? ListView.empty() : ((ListView)((Pair)splitPath).second).tail();
                            continue block15;
                        }
                        case VERSION_2: {
                            Preconditions.checkState(!globAlreadyMatched, "Nested glob rules are not allowed");
                            PathMatcher.matchAfterGlob(resourcePath, ImmutableList.copyOf(ruleSegments.subList(i, ruleSegments.size())), variables.build(), parentNode, collector, rule);
                            return;
                        }
                        case UNRECOGNIZED: {
                            throw new AssertionError((Object)"unreachable");
                        }
                    }
                    continue block15;
                }
                case CAPTURE: {
                    String variableName = ruleSegment.getCapture().getName();
                    if (resourcePath.isEmpty()) {
                        return;
                    }
                    ExpressionPathSegmentValue resourcePathSegment = resourcePath.head();
                    resourcePath = resourcePath.tail();
                    switch (resourcePathSegment.getKindCase()) {
                        case SIMPLE: {
                            variables.put(variableName, Suppliers.ofInstance(Futures.immediateFuture(ExpressionValueUtils.createValue((Object)resourcePathSegment.getSimple()))));
                            continue block15;
                        }
                        case CAPTURE: {
                            continue block15;
                        }
                        case GLOB_CAPTURE: {
                            return;
                        }
                    }
                    Object splitPath = String.valueOf(resourcePathSegment.getKindCase());
                    throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(splitPath).length()).append("Unsupported path kind: ").append((String)splitPath).toString());
                }
                case EXPRESSION: {
                    String matcherValue = PathMatcher.literalSegmentValue(ruleSegment);
                    if (resourcePath.isEmpty()) {
                        return;
                    }
                    ExpressionPathSegmentValue resourcePathSegment = resourcePath.head();
                    resourcePath = resourcePath.tail();
                    if (resourcePathSegment.getKindCase() == ExpressionPathSegmentValue.KindCase.SIMPLE && matcherValue.equals(resourcePathSegment.getSimple())) continue block15;
                    return;
                }
                default: {
                    String string = String.valueOf(ruleSegment);
                    throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length()).append("Invalid type for path part ").append(string).toString());
                }
            }
        }
        ExecutionContext executionContext = ExecutionContext.builder().scopeAstElement(rule).variables(variables.build()).build();
        ParentPointer<ExecutionContext> childActivation = parentNode.makeChild((ExecutionContext)executionContext);
        if (resourcePath.isEmpty()) {
            collector.accept(childActivation);
            if (globAlreadyMatched) {
                return;
            }
        }
        PathMatcher.matchRules(resourcePath, rule.getMatchRulesList(), childActivation, collector, version, globAlreadyMatched);
    }

    private static <T extends ParentPointer<ExecutionContext>> void matchAfterGlob(ListView<ExpressionPathSegmentValue> resourcePath, ImmutableList<Path.PathSegment> globThenSegments, ImmutableMap<String, java.util.function.Supplier<ListenableFuture<ExpressionValue>>> currentVariables, T parentNode, Consumer<T> collector, MatchRule ruleWithGlob) {
        Preconditions.checkArgument(!globThenSegments.isEmpty() && ((Path.PathSegment)globThenSegments.get(0)).hasGlobCapture());
        String globName = ((Path.PathSegment)globThenSegments.get(0)).getGlobCapture().getName();
        List ruleSegments = globThenSegments.subList(1, globThenSegments.size());
        int maxCaptureSize = resourcePath.size() - ((AbstractCollection)((Object)ruleSegments)).size();
        for (int globSegmentsCaptured = 0; globSegmentsCaptured <= maxCaptureSize; ++globSegmentsCaptured) {
            ListView<ExpressionPathSegmentValue> globCapture = resourcePath.take(globSegmentsCaptured);
            ImmutableMap.Builder<String, java.util.function.Supplier<ListenableFuture<ExpressionValue>>> variables = ImmutableMap.builder();
            variables.putAll(currentVariables).put(globName, PathMatcher.makeV2PathExpression(globCapture));
            ListView<ExpressionPathSegmentValue> suffix = resourcePath.drop(globSegmentsCaptured);
            if (!PathMatcher.matchRuleSegments(suffix, (ImmutableList<Path.PathSegment>)ruleSegments, variables)) continue;
            ExecutionContext executionContext = ExecutionContext.builder().scopeAstElement(ruleWithGlob).variables(variables.build()).build();
            ParentPointer<ExecutionContext> childActivation = parentNode.makeChild((ExecutionContext)executionContext);
            if (suffix.size() == ((AbstractCollection)((Object)ruleSegments)).size()) {
                collector.accept(childActivation);
                return;
            }
            PathMatcher.matchRules(suffix, ruleWithGlob.getMatchRulesList(), childActivation, collector, RulesetAst.Version.VERSION_2, true);
        }
    }

    private static boolean matchRuleSegments(ListView<ExpressionPathSegmentValue> resourceSegments, ImmutableList<Path.PathSegment> ruleSegments, ImmutableMap.Builder<String, java.util.function.Supplier<ListenableFuture<ExpressionValue>>> variables) {
        block9: for (int i = 0; i < ruleSegments.size(); ++i) {
            Path.PathSegment segment = (Path.PathSegment)ruleSegments.get(i);
            ExpressionPathSegmentValue resourceSegment = resourceSegments.get(i);
            switch (segment.getKindCase()) {
                case CAPTURE: {
                    String variableName = segment.getCapture().getName();
                    switch (resourceSegment.getKindCase()) {
                        case SIMPLE: {
                            variables.put(variableName, Suppliers.ofInstance(Futures.immediateFuture(ExpressionValueUtils.createValue((Object)resourceSegment.getSimple()))));
                            continue block9;
                        }
                        case CAPTURE: {
                            continue block9;
                        }
                        case GLOB_CAPTURE: {
                            return false;
                        }
                    }
                    String string = String.valueOf(resourceSegment.getKindCase());
                    throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unsupported path kind: ").append(string).toString());
                }
                case EXPRESSION: {
                    String matcherValue = PathMatcher.literalSegmentValue(segment);
                    if (resourceSegment.getKindCase() == ExpressionPathSegmentValue.KindCase.SIMPLE && matcherValue.equals(resourceSegment.getSimple())) continue block9;
                    return false;
                }
                default: {
                    String string = String.valueOf(segment);
                    throw new IllegalArgumentException(new StringBuilder(27 + String.valueOf(string).length()).append("Invalid type for path part ").append(string).toString());
                }
            }
        }
        return true;
    }

    private static java.util.function.Supplier<ListenableFuture<ExpressionValue>> makeV2PathExpression(Iterable<ExpressionPathSegmentValue> globPathSegments) {
        return Suppliers.ofInstance(Futures.immediateFuture(ExpressionValueUtils.createValue(ExpressionPathValue.newBuilder().addAllSegments(globPathSegments).build())));
    }

    private static String literalSegmentValue(Path.PathSegment segment) {
        Preconditions.checkArgument(segment.hasExpression());
        Expression expr = segment.getExpression();
        Preconditions.checkArgument(expr.getExpressionCase() == Expression.ExpressionCase.LITERAL && expr.getLiteral().getKindCase() == Literal.KindCase.STRING_VALUE, "Invalid type for path segment: %s", (Object)segment);
        return expr.getLiteral().getStringValue();
    }

    private static boolean canShortCircuitMatching(int remainingResourcePathSize, int remainingRulePathSize, RulesetAst.Version version) {
        switch (version) {
            case VERSION_UNSPECIFIED: 
            case VERSION_1: {
                return remainingRulePathSize > remainingResourcePathSize;
            }
            case VERSION_2: {
                return remainingRulePathSize - 1 > remainingResourcePathSize;
            }
        }
        throw new IllegalArgumentException("Unknown rules version");
    }
}

