/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.flogger.GoogleLogger;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AsyncRuntimeFunction;
import com.google.firebase.rules.runtime.common.BaseFunction;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.EvaluationListener;
import com.google.firebase.rules.runtime.common.RestrictionException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.Activation;
import com.google.firebase.rules.runtime.impl.EvaluationManager;
import com.google.firebase.rules.runtime.impl.ExecutableExpression;
import com.google.firebase.rules.runtime.impl.Program;
import com.google.firebase.rules.runtime.impl.functions.Path;
import com.google.firebase.rules.runtime.impl.functions.ToString;
import com.google.firebase.rules.runtime.impl.types.PathType;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.Binding;
import com.google.firebase.rules.runtime.v1.BindingExpression;
import com.google.firebase.rules.runtime.v1.CallExpression;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.Expression;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathSegmentValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.Identifier;
import com.google.firebase.rules.runtime.v1.ListExpression;
import com.google.firebase.rules.runtime.v1.Literal;
import com.google.firebase.rules.runtime.v1.MapExpression;
import com.google.firebase.rules.runtime.v1.Member;
import com.google.firebase.rules.runtime.v1.Path;
import com.google.firebase.rules.v1.SourcePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import javax.annotation.Nullable;

public class StackMachine {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/firebase/rules/runtime/impl/StackMachine");
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private final EvaluationListener evaluationListener;
    private final Program program;
    private final SettableFuture<ExpressionValue> result;
    private final EvaluationManager evaluationManager;
    private volatile ListenableFuture<?> awaitingFuture = null;

    StackMachine(Program program) {
        this.program = program;
        this.evaluationManager = program.evaluationManager();
        this.evaluationListener = program.evaluationListener();
        this.result = SettableFuture.create();
    }

    public ListenableFuture<ExpressionValue> evaluate() {
        this.evaluateNextExpression();
        Futures.addCallback(this.result, new FutureCallback<ExpressionValue>(){

            @Override
            public void onSuccess(@Nullable ExpressionValue expressionValue) {
            }

            @Override
            public void onFailure(Throwable throwable) {
                if (throwable instanceof CancellationException && StackMachine.this.awaitingFuture != null) {
                    StackMachine.this.awaitingFuture.cancel(true);
                }
            }
        }, MoreExecutors.directExecutor());
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateNextExpression() {
        this.awaitingFuture = null;
        boolean blocked = false;
        this.evaluationManager.startMeasuringThreadTime();
        try {
            Expression expr;
            while (!blocked && !this.result.isDone() && (expr = this.program.getNextExpression()) != null) {
                try {
                    this.evaluationManager.canEvaluate(expr);
                }
                catch (RestrictionException maxNumberOfExpressionReached) {
                    this.result.setException(maxNumberOfExpressionReached);
                    this.evaluationManager.stopMeasuringThreadTime();
                    return;
                }
                blocked = this.evaluateExpression(expr);
            }
            if (!blocked && !this.result.isDone()) {
                ExpressionValue returnValue = this.popValue();
                if (ExpressionValueUtils.isUndefined(returnValue)) {
                    this.result.setException(ExpressionValueUtils.propagateUndefined(returnValue));
                } else {
                    this.result.set(returnValue);
                }
            }
        }
        finally {
            this.evaluationManager.stopMeasuringThreadTime();
        }
    }

    private boolean evaluateExpression(Expression expr) {
        switch (expr.getExpressionCase()) {
            case LITERAL: {
                return this.evaluateLiteral(expr);
            }
            case MEMBER: {
                return this.evaluateMember(expr);
            }
            case LIST: {
                return this.evaluateList(expr);
            }
            case PATH: {
                return this.evaluatePath(expr);
            }
            case MAP: {
                return this.evaluateMap(expr);
            }
            case CALL: {
                return this.evaluateCall(expr);
            }
            case BINDING: {
                return this.evaluateBinding(expr);
            }
        }
        String string = String.valueOf(expr.getSourcePosition());
        throw new RuntimeException(new StringBuilder(29 + String.valueOf(string).length()).append("Cannot find expression type: ").append(string).toString());
    }

    private boolean evaluateLiteral(Expression expr) {
        Literal literal = expr.getLiteral();
        switch (literal.getKindCase()) {
            case BOOL_VALUE: {
                return this.pushValue(ExpressionValueUtils.createValue(literal.getBoolValue()));
            }
            case DOUBLE_VALUE: {
                return this.pushValue(ExpressionValueUtils.createValue(literal.getDoubleValue()));
            }
            case LONG_VALUE: {
                return this.pushValue(ExpressionValueUtils.createValue(literal.getLongValue()));
            }
            case STRING_VALUE: {
                return this.pushValue(ExpressionValueUtils.createValue((Object)literal.getStringValue()));
            }
            case BYTES_VALUE: {
                return this.pushValue(ExpressionValueUtils.createValue((Object)literal.getBytesValue()));
            }
            case NULL_VALUE: {
                return this.pushValue(ExpressionValueUtils.NULL);
            }
            case DURATION_VALUE: {
                return this.pushValue(ExpressionValueUtils.createValue((Object)literal.getDurationValue()));
            }
        }
        SourcePosition sourcePosition = expr.getSourcePosition();
        String string = String.valueOf(sourcePosition);
        throw new RuntimeException(new StringBuilder(29 + String.valueOf(string).length()).append("Cannot find expression type: ").append(string).toString());
    }

    private boolean evaluateMember(Expression expr) {
        Member member = expr.getMember();
        Identifier memberId = member.getId();
        if (!member.hasOperand()) {
            ListenableFuture<ExpressionValue> value;
            try {
                value = this.program.activation().getVariable(memberId.getName());
            }
            catch (RuntimeException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/StackMachine", "evaluateMember", 285, "StackMachine.java")).log("Unchecked exception encountered when fetching variables for member: %s", memberId.getName());
                return this.pushException(EvaluationException.makeVariableReadError(memberId.getSourcePosition(), memberId.getName(), e));
            }
            if (value == null) {
                return this.pushException(EvaluationException.makeNullValueError(memberId.getSourcePosition()));
            }
            return this.pushVariable(memberId, value);
        }
        ExpressionValue value = this.popValue();
        if (ExpressionValueUtils.isUndefined(value)) {
            return this.pushValue(value);
        }
        if (ExpressionValueUtils.isNull(value)) {
            return this.pushException(EvaluationException.makeNullValueError(member.getOperand().getSourcePosition()));
        }
        String name = member.getId().getName();
        if (ExpressionValueUtils.isMap(value)) {
            Map<String, ExpressionValue> values = value.getMapValue().getFieldsMap();
            if (values.containsKey(name)) {
                return this.pushValue(values.get(name));
            }
            return this.pushException(EvaluationException.makeUndefinedPropertyError(expr.getSourcePosition(), name));
        }
        if (ExpressionValueUtils.isPath(value)) {
            try {
                return this.pushValue(PathType.getPathBoundVariable(value.getPathValue(), name, expr.getSourcePosition()));
            }
            catch (EvaluationException e) {
                return this.pushException(e);
            }
        }
        return this.pushException(EvaluationException.makeTypeError(expr.getSourcePosition(), value.getKindCase(), ExpressionValue.KindCase.MAP_VALUE, ExpressionValue.KindCase.PATH_VALUE));
    }

    private boolean evaluateList(Expression expr) {
        ListExpression listExpression = expr.getList();
        ArrayList<ExpressionValue> values = new ArrayList<ExpressionValue>();
        for (int i = 0; i < listExpression.getExpressionsCount(); ++i) {
            ExpressionValue value = this.popValue();
            if (ExpressionValueUtils.isUndefined(value)) {
                return this.pushValue(value);
            }
            values.add(value);
        }
        return this.pushValue(ExpressionValueUtils.createValue(values));
    }

    private boolean evaluatePath(Expression expr) {
        com.google.firebase.rules.runtime.v1.Path path = expr.getPath();
        ExpressionPathValue.Builder value = ExpressionPathValue.newBuilder();
        for (Path.PathSegment segment : path.getSegmentsList()) {
            switch (segment.getKindCase()) {
                case CAPTURE: {
                    value.addSegments(ExpressionPathSegmentValue.newBuilder().setCapture(ExpressionPathSegmentValue.Capture.newBuilder().setVariableName(segment.getCapture().getName())));
                    break;
                }
                case GLOB_CAPTURE: {
                    value.addSegments(ExpressionPathSegmentValue.newBuilder().setGlobCapture(ExpressionPathSegmentValue.GlobCapture.newBuilder().setVariableName(segment.getGlobCapture().getName())));
                    break;
                }
                case EXPRESSION: {
                    Expression exp = segment.getExpression();
                    ExpressionValue expressionValue = this.popValue();
                    if (ExpressionValueUtils.isPath(expressionValue)) {
                        value.addAllSegments(expressionValue.getPathValue().getSegmentsList());
                        break;
                    }
                    if (ExpressionValueUtils.isUndefined(expressionValue)) {
                        return this.pushValue(expressionValue);
                    }
                    try {
                        value.addSegments(ExpressionPathSegmentValue.newBuilder().setSimple(ToString.stringify(exp.getSourcePosition(), expressionValue)));
                        break;
                    }
                    catch (EvaluationException e) {
                        return this.pushException(e);
                    }
                }
                case KIND_NOT_SET: {
                    String string = String.valueOf(segment.getKindCase());
                    throw new RuntimeException(new StringBuilder(22 + String.valueOf(string).length()).append("Unknown segment kind: ").append(string).toString());
                }
            }
        }
        try {
            Path.validatePath(expr.getSourcePosition(), value);
            return this.pushValue(ExpressionValueUtils.createValue(value.build()));
        }
        catch (EvaluationException e) {
            return this.pushException(e);
        }
    }

    private boolean evaluateMap(Expression expr) {
        MapExpression mapExpression = expr.getMap();
        int size = mapExpression.getKeysCount();
        ExpressionMapValue.Builder mapValue = ExpressionMapValue.newBuilder();
        Expression badKeyExpr = null;
        ExpressionValue badKey = null;
        ExpressionValue badValue = null;
        for (int i = 0; i < size; ++i) {
            Expression keyExpr = mapExpression.getKeys(i);
            ExpressionValue keyValue = this.popValue();
            ExpressionValue valueValue = this.popValue();
            if (ExpressionValueUtils.isString(keyValue) && !ExpressionValueUtils.isUndefined(valueValue)) {
                String key = keyValue.getStringValue();
                mapValue.putFields(key, valueValue);
                continue;
            }
            if (badKey == null && !ExpressionValueUtils.isString(keyValue)) {
                badKeyExpr = keyExpr;
                badKey = keyValue;
                continue;
            }
            if (badValue != null || !ExpressionValueUtils.isUndefined(valueValue)) continue;
            badValue = valueValue;
        }
        if (badKey != null) {
            if (ExpressionValueUtils.isUndefined(badKey)) {
                return this.pushValue(badKey);
            }
            return this.pushException(EvaluationException.makeTypeError(badKeyExpr.getSourcePosition(), badKey.getKindCase(), ExpressionValue.KindCase.STRING_VALUE));
        }
        if (badValue != null) {
            Preconditions.checkArgument(ExpressionValueUtils.isUndefined(badValue));
            return this.pushValue(badValue);
        }
        return this.pushValue(ExpressionValue.newBuilder().setMapValue(mapValue).build());
    }

    private boolean evaluateCall(Expression expr) {
        CallExpression call = expr.getCall();
        Identifier functionId = call.getFunctionName();
        if (FunctionTemplate.BuiltInBooleanOperator.isShortCircuit(functionId.getName())) {
            return this.evaluateShortCircuit(expr);
        }
        return this.callFunction(expr);
    }

    private boolean evaluateShortCircuit(Expression expression) {
        CallExpression call = expression.getCall();
        Identifier functionId = call.getFunctionName();
        String functionName = functionId.getName();
        if (functionName.equals(FunctionTemplate.BuiltInBooleanOperator.JUMP_IF.getFunctionName())) {
            return this.evaluateJump(expression);
        }
        Preconditions.checkArgument(functionName.equals(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_AND.getFunctionName()) || functionName.equals(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_OR.getFunctionName()), "Unsupported short-circuit function: %s", (Object)functionName);
        return this.evaluateBoolean(expression);
    }

    private boolean evaluateJump(Expression expression) {
        ExpressionValue jumpState = this.program.stack().peek();
        if (ExpressionValueUtils.isBool(jumpState)) {
            CallExpression call = expression.getCall();
            List<Expression> arguments = call.getArgumentsList();
            boolean jumpCondition = arguments.get(0).getLiteral().getBoolValue();
            if (jumpState.getBoolValue() == jumpCondition) {
                int jumpCount = Math.toIntExact(arguments.get(1).getLiteral().getLongValue());
                this.program.incrementProgramCounter(jumpCount);
            }
            return false;
        }
        if (ExpressionValueUtils.isUndefined(jumpState)) {
            return false;
        }
        this.popValue();
        return this.pushException(EvaluationException.makeTypeError(expression.getSourcePosition(), jumpState.getKindCase(), ExpressionValue.KindCase.BOOL_VALUE));
    }

    private boolean evaluateBoolean(Expression expression) {
        CallExpression call = expression.getCall();
        String functionName = call.getFunctionName().getName();
        ExpressionValue currState = this.popValue();
        ExpressionValue prevState = this.popValue();
        if (ExpressionValueUtils.isBool(currState) && ExpressionValueUtils.isBool(prevState)) {
            return this.pushValue(currState);
        }
        if (ExpressionValueUtils.isBool(currState)) {
            boolean stateValue = currState.getBoolValue();
            if (stateValue && functionName.equals(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_OR.getFunctionName()) || !stateValue && functionName.equals(FunctionTemplate.BuiltInBooleanOperator.BOOLEAN_AND.getFunctionName())) {
                return this.pushValue(currState);
            }
            return this.pushValue(prevState);
        }
        if (ExpressionValueUtils.isUndefined(prevState)) {
            return this.pushValue(prevState);
        }
        if (ExpressionValueUtils.isUndefined(currState)) {
            return this.pushValue(currState);
        }
        return this.pushException(EvaluationException.makeTypeError(expression.getSourcePosition(), currState.getKindCase(), ExpressionValue.KindCase.BOOL_VALUE));
    }

    private boolean callFunction(Expression expression) {
        BaseFunction function;
        ExecutionRequest request;
        CallExpression call = expression.getCall();
        Identifier functionId = call.getFunctionName();
        String functionName = functionId.getName();
        if (call.hasPackageName()) {
            String string = call.getPackageName().getName();
            String string2 = functionName;
            functionName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
        }
        ExecutionRequest.Builder requestBuilder = ExecutionRequest.newBuilder().setFunctionName(functionId.getName()).setSourcePosition(functionId.getSourcePosition());
        ExpressionValue.KindCase operandKindCase = null;
        if (call.hasOperand()) {
            ExpressionValue operand = this.popValue();
            operandKindCase = operand != null ? operand.getKindCase() : null;
            requestBuilder.setOperand(operand);
        }
        for (int i = 0; i < call.getArgumentsCount(); ++i) {
            ExpressionValue argValue = this.popValue();
            requestBuilder.addArguments(argValue);
        }
        if (requestBuilder.hasOperand()) {
            ExpressionValue operand = requestBuilder.getOperand();
            if (ExpressionValueUtils.isUndefined(operand)) {
                return this.pushValue(operand);
            }
            if (ExpressionValueUtils.isNull(operand)) {
                return this.pushException(EvaluationException.makeNullValueError(requestBuilder.getSourcePosition()));
            }
        }
        if (!(request = requestBuilder.build()).hasOperand()) {
            try {
                ExecutableExpression executableExpression = this.program.activation().lookupLocalFunction(request);
                if (executableExpression != null) {
                    this.program.pushExecution(executableExpression);
                    return false;
                }
            }
            catch (EvaluationException e) {
                return this.pushException(e);
            }
        }
        try {
            function = this.program.activation().getFunction(operandKindCase, functionName);
        }
        catch (Exception e) {
            this.evaluationListener.functionNotFound(request, this.program.activation());
            return this.pushException(EvaluationException.makeFunctionNotFoundError(expression.getSourcePosition(), functionName));
        }
        if (function == null) {
            this.evaluationListener.functionNotFound(request, this.program.activation());
            return this.pushException(EvaluationException.makeFunctionNotFoundError(expression.getSourcePosition(), functionName));
        }
        return this.executeFunction(function, request, functionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeFunction(BaseFunction baseFunction, ExecutionRequest request, Identifier functionId) {
        Object asyncResponse;
        Preconditions.checkArgument(baseFunction instanceof RuntimeFunction || baseFunction instanceof AsyncRuntimeFunction, "Unsupported function type. Expected 'RuntimeFunction' or 'AsyncRuntimeFunction'.");
        for (ExpressionValue arg : request.getArgumentsList()) {
            if (!ExpressionValueUtils.isUndefined(arg)) continue;
            return this.pushValue(arg);
        }
        if (baseFunction instanceof RuntimeFunction) {
            try {
                return this.pushValue(Preconditions.checkNotNull(((RuntimeFunction)baseFunction).execute(request)).getValue());
            }
            catch (EvaluationException e) {
                return this.pushException(e);
            }
        }
        AsyncRuntimeFunction asyncRuntimeFunction = (AsyncRuntimeFunction)baseFunction;
        long uid = ID_GENERATOR.incrementAndGet();
        this.evaluationListener.beforeAsyncFunction(uid, request, this.program.activation());
        try {
            this.evaluationManager.stopMeasuringThreadTime();
            asyncResponse = asyncRuntimeFunction.execute(request);
        }
        catch (RuntimeException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/StackMachine", "executeFunction", 658, "StackMachine.java")).log("Unchecked exception encountered when executing async function: %s", asyncRuntimeFunction.name());
            String argValues = Joiner.on(", ").join(request.getArgumentsList());
            boolean bl = this.pushException(EvaluationException.makeServiceCallError(request.getSourcePosition(), request.getFunctionName(), argValues, e));
            return bl;
        }
        finally {
            this.evaluationManager.startMeasuringThreadTime();
        }
        this.attachErrorLoggerToFuture((ListenableFuture)asyncResponse, Level.FINE, "Unable to execute function %s", functionId);
        this.evaluationListener.afterAsyncFunction(uid, request, this.program.activation(), (ListenableFuture<ExecutionResponse>)asyncResponse);
        if (asyncResponse.isDone()) {
            try {
                ExecutionResponse doneResponse = (ExecutionResponse)asyncResponse.get();
                if (doneResponse == null) {
                    return this.pushException(EvaluationException.makeNullValueError(request.getSourcePosition()));
                }
                return this.pushValue(doneResponse.getValue());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RestrictionException) {
                    this.result.setException(cause);
                    return true;
                }
                return this.pushException(this.makeServiceCallException(request, cause));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (CancellationException e) {
                this.result.cancel(false);
                return true;
            }
        }
        return this.resolveAsyncResponse(request, (ListenableFuture<ExecutionResponse>)asyncResponse);
    }

    private boolean evaluateBinding(Expression expression) {
        BindingExpression binding = expression.getBinding();
        ImmutableMap.Builder<String, ExpressionValue> variables = ImmutableMap.builder();
        for (Binding b : binding.getBindingsList()) {
            ExpressionValue value = this.popValue();
            variables.put(b.getId().getName(), value);
        }
        Activation child = this.program.activation().makeNewScope(variables.build());
        this.program.pushExecution(new ExecutableExpression(binding.getBody(), child));
        return false;
    }

    private boolean resolveAsyncVariable(final Identifier variable, ListenableFuture<ExpressionValue> value) {
        this.awaitingFuture = value;
        Futures.addCallback(value, new FutureCallback<ExpressionValue>(){

            @Override
            public void onSuccess(ExpressionValue value) {
                StackMachine.this.pushValue(value);
                StackMachine.this.evaluateNextExpression();
            }

            @Override
            public void onFailure(Throwable cause) {
                if (cause instanceof CancellationException) {
                    StackMachine.this.result.cancel(true);
                    return;
                }
                StackMachine.this.pushException(EvaluationException.makeVariableReadError(variable.getSourcePosition(), variable.getName(), cause));
                StackMachine.this.evaluateNextExpression();
            }
        }, MoreExecutors.directExecutor());
        return true;
    }

    private boolean resolveAsyncResponse(final ExecutionRequest request, ListenableFuture<ExecutionResponse> value) {
        this.awaitingFuture = value;
        Futures.addCallback(value, new FutureCallback<ExecutionResponse>(){

            @Override
            public void onSuccess(ExecutionResponse response) {
                if (response == null) {
                    StackMachine.this.pushException(EvaluationException.makeNullValueError(request.getSourcePosition()));
                } else {
                    StackMachine.this.pushValue(response.getValue());
                    StackMachine.this.evaluateNextExpression();
                }
            }

            @Override
            public void onFailure(Throwable cause) {
                if (cause instanceof CancellationException) {
                    StackMachine.this.result.cancel(true);
                    return;
                }
                if (cause instanceof RestrictionException) {
                    StackMachine.this.result.setException(cause);
                    return;
                }
                String argValues = Joiner.on(", ").join(request.getArgumentsList());
                StackMachine.this.pushException(EvaluationException.makeServiceCallError(request.getSourcePosition(), request.getFunctionName(), argValues, cause));
                StackMachine.this.evaluateNextExpression();
            }
        }, MoreExecutors.directExecutor());
        return true;
    }

    private ExpressionValue popValue() {
        ExpressionValue result = this.program.stack().pop();
        this.evaluationManager.valuePopped(result);
        return result;
    }

    private boolean pushValue(ExpressionValue value) {
        this.program.stack().push(value);
        this.evaluationManager.valuePushed(value);
        return false;
    }

    private EvaluationException makeServiceCallException(ExecutionRequest request, Throwable cause) {
        if (cause instanceof EvaluationException) {
            return (EvaluationException)cause;
        }
        String argValues = Joiner.on(", ").join(request.getArgumentsList());
        return EvaluationException.makeServiceCallError(request.getSourcePosition(), request.getFunctionName(), argValues, cause);
    }

    private boolean pushException(EvaluationException evaluationException) {
        ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(evaluationException)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/StackMachine", "pushException", 806, "StackMachine.java")).log("Exception during evaluation of an expression: %s", evaluationException.getSourcePosition());
        ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atFinest()).withCause(evaluationException)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/StackMachine", "pushException", 814, "StackMachine.java")).log("Put evaluation exception in to the value stack.");
        return this.pushValue(evaluationException.toUndefinedValue());
    }

    private boolean pushVariable(Identifier variable, ListenableFuture<ExpressionValue> value) {
        if (value.isDone()) {
            try {
                return this.pushValue((ExpressionValue)value.get());
            }
            catch (ExecutionException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).atMostEvery(5, TimeUnit.SECONDS)).withCause(e.getCause())).withInjectedLogSite("com/google/firebase/rules/runtime/impl/StackMachine", "pushVariable", 824, "StackMachine.java")).log("Unable to read variable %s", variable);
                if (e.getCause() instanceof EvaluationException) {
                    return this.pushException((EvaluationException)e.getCause());
                }
                return this.pushException(EvaluationException.makeVariableReadError(variable.getSourcePosition(), variable.getName(), e));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (CancellationException e) {
                this.result.cancel(false);
                return true;
            }
        }
        this.attachErrorLoggerToFuture(value, Level.WARNING, "Unable to read variable %s", variable);
        return this.resolveAsyncVariable(variable, value);
    }

    private <T> void attachErrorLoggerToFuture(ListenableFuture<T> future, final Level level, final String message, final Object ... params) {
        if (logger.at(level).isEnabled()) {
            Preconditions.checkNotNull(future);
            Futures.addCallback(future, new FutureCallback<T>(this){

                @Override
                public void onSuccess(T t) {
                }

                @Override
                public void onFailure(Throwable cause) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)((GoogleLogger.Api)logger.at(level).atMostEvery(5, TimeUnit.SECONDS)).withCause(cause)).withInjectedLogSite("com/google/firebase/rules/runtime/impl/StackMachine$4", "onFailure", 856, "StackMachine.java")).logVarargs(message, params);
                }
            }, MoreExecutors.directExecutor());
        }
    }
}

