/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl;

import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.IdentityHashMap;

public class StackSizeMonitor {
    private long totalStackSize = 0L;
    private final IdentityHashMap<ExpressionValue, Integer> refCounts = new IdentityHashMap();

    void valuePopped(ExpressionValue expressionValue) {
        int count = this.refCounts.get(expressionValue);
        if (count == 1) {
            this.refCounts.remove(expressionValue);
            this.totalStackSize -= (long)expressionValue.getSerializedSize();
        } else {
            this.refCounts.put(expressionValue, count - 1);
        }
    }

    void valuePushed(ExpressionValue expressionValue) {
        Integer count = this.refCounts.get(expressionValue);
        if (count == null) {
            this.refCounts.put(expressionValue, 1);
            this.totalStackSize += (long)expressionValue.getSerializedSize();
        } else {
            this.refCounts.put(expressionValue, count + 1);
        }
    }

    long getTotalStackSize() {
        return this.totalStackSize;
    }
}

