/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;

public final class Divide
extends OverloadedRuntimeFunction {
    public Divide() {
        super((FunctionTemplate)FunctionTemplate.BuiltInMathOperator.DIVIDE, new DivideInt(), new DivideNumber());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class DivideNumber
    implements RuntimeFunction {
        private DivideNumber() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            double leftValue = request.getArguments(0).getFloatValue();
            double rightValue = request.getArguments(1).getFloatValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(leftValue / rightValue));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class DivideInt
    implements RuntimeFunction {
        private DivideInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            long leftValue = request.getArguments(0).getIntValue();
            long rightValue = request.getArguments(1).getIntValue();
            if (rightValue == 0L) {
                throw EvaluationException.makeDivideByZeroError(request.getSourcePosition());
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(leftValue / rightValue));
        }
    }
}

