/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.units.DurationUtil;

@FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
public class DurationTime
extends GuardedRuntimeFunction {
    public DurationTime() {
        super(FunctionTemplate.BuiltInTypeConversionFunction.DURATION_TIME);
    }

    @Override
    public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
        long hrs = request.getArguments(0).getIntValue();
        long min = request.getArguments(1).getIntValue();
        long secs = request.getArguments(2).getIntValue();
        long nanos = request.getArguments(3).getIntValue();
        try {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)DurationUtil.makeDuration(hrs, min, secs, nanos)));
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw EvaluationException.makeInvalidTimestampError(request.getSourcePosition());
        }
    }
}

