/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.units.DurationUnitConverter;

@FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.STRING})
public class DurationValue
extends GuardedRuntimeFunction {
    private final DurationUnitConverter durationUnitConverter = new DurationUnitConverter();

    public DurationValue() {
        super(FunctionTemplate.BuiltInTypeConversionFunction.DURATION_VALUE);
    }

    @Override
    public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
        String suffix = request.getArguments(1).getStringValue();
        long value = request.getArguments(0).getIntValue();
        if (this.durationUnitConverter.matches(suffix)) {
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)this.durationUnitConverter.convert(value, suffix)));
            }
            catch (ArithmeticException | IllegalArgumentException e) {
                throw EvaluationException.makeInvalidDurationError(request.getSourcePosition());
            }
        }
        throw EvaluationException.makeUnknownDurationSuffixError(request.getSourcePosition(), suffix);
    }
}

