/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ConstraintValueUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;

public final class Equals
extends OverloadedRuntimeFunction {
    public Equals() {
        super((FunctionTemplate)FunctionTemplate.BuiltInBooleanOperator.EQUALS, new EqualsInteger(), new EqualsFloat(), new EqualsAny());
    }

    private static ExecutionResponse constraintEqualsCheck(ExecutionRequest request, ConstraintValue constraintValue, ExpressionValue expressionValue) throws EvaluationException {
        SimpleConstraint rightConstraint = ExpressionValueUtils.makeSimpleConstraint(SimpleConstraint.Comparator.EQ, expressionValue, request.getSourcePosition());
        return ExpressionValueUtils.createResponse(ConstraintValueUtils.implies(constraintValue, rightConstraint));
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY, FunctionExpects.ExpectedExpressionKind.ANY})
    private static class EqualsAny
    extends EqualsObject {
        private EqualsAny() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class EqualsFloat
    extends EqualsObject {
        private EqualsFloat() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class EqualsInteger
    extends EqualsObject {
        private EqualsInteger() {
        }
    }

    private static class EqualsObject
    implements RuntimeFunction {
        private EqualsObject() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue leftValue = request.getArguments(0);
            ExpressionValue rightValue = request.getArguments(1);
            if (ExpressionValueUtils.isConstraint(leftValue) && ExpressionValueUtils.isConstraint(rightValue)) {
                throw EvaluationException.makeTypeError(request.getSourcePosition(), ExpressionValue.KindCase.CONSTRAINT_VALUE, KindCaseHelper.COMPARABLE_KIND_CASES);
            }
            if (ExpressionValueUtils.isConstraint(leftValue)) {
                return Equals.constraintEqualsCheck(request, leftValue.getConstraintValue(), rightValue);
            }
            if (ExpressionValueUtils.isConstraint(rightValue)) {
                return Equals.constraintEqualsCheck(request, rightValue.getConstraintValue(), leftValue);
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(ExpressionValueUtils.equal(leftValue, rightValue)));
        }
    }
}

