/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.BaseFunction;
import com.google.firebase.rules.runtime.common.FunctionProvider;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.functions.Abs;
import com.google.firebase.rules.runtime.impl.functions.Add;
import com.google.firebase.rules.runtime.impl.functions.BooleanNot;
import com.google.firebase.rules.runtime.impl.functions.Ceil;
import com.google.firebase.rules.runtime.impl.functions.Divide;
import com.google.firebase.rules.runtime.impl.functions.DurationAbs;
import com.google.firebase.rules.runtime.impl.functions.DurationTime;
import com.google.firebase.rules.runtime.impl.functions.DurationValue;
import com.google.firebase.rules.runtime.impl.functions.Equals;
import com.google.firebase.rules.runtime.impl.functions.Floor;
import com.google.firebase.rules.runtime.impl.functions.GreaterThan;
import com.google.firebase.rules.runtime.impl.functions.GreaterThanOrEquals;
import com.google.firebase.rules.runtime.impl.functions.HashingFunction;
import com.google.firebase.rules.runtime.impl.functions.IsInfinity;
import com.google.firebase.rules.runtime.impl.functions.IsNaN;
import com.google.firebase.rules.runtime.impl.functions.IsType;
import com.google.firebase.rules.runtime.impl.functions.LatLngValue;
import com.google.firebase.rules.runtime.impl.functions.LessThan;
import com.google.firebase.rules.runtime.impl.functions.LessThanOrEquals;
import com.google.firebase.rules.runtime.impl.functions.Minus;
import com.google.firebase.rules.runtime.impl.functions.Modulus;
import com.google.firebase.rules.runtime.impl.functions.Multiply;
import com.google.firebase.rules.runtime.impl.functions.Negate;
import com.google.firebase.rules.runtime.impl.functions.NotEquals;
import com.google.firebase.rules.runtime.impl.functions.Path;
import com.google.firebase.rules.runtime.impl.functions.Round;
import com.google.firebase.rules.runtime.impl.functions.TimestampDate;
import com.google.firebase.rules.runtime.impl.functions.TimestampEpoch;
import com.google.firebase.rules.runtime.impl.functions.ToFloat;
import com.google.firebase.rules.runtime.impl.functions.ToInt;
import com.google.firebase.rules.runtime.impl.functions.ToString;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.Map;
import javax.annotation.Nullable;

public class GlobalFunctions
implements FunctionProvider {
    private final Map<String, BaseFunction> functionMap;
    private static final HashFunction MD5_HASH = Hashing.md5();

    public GlobalFunctions() {
        ImmutableMap.Builder<String, RuntimeFunction> builder = ImmutableMap.builder();
        builder.put(FunctionTemplate.BuiltInMathOperator.ADD.getFunctionName(), new Add());
        builder.put(FunctionTemplate.BuiltInMathOperator.MINUS.getFunctionName(), new Minus());
        builder.put(FunctionTemplate.BuiltInUnaryOperator.NEGATE_NUMBER.getFunctionName(), new Negate());
        builder.put(FunctionTemplate.BuiltInMathOperator.MULTIPLY.getFunctionName(), new Multiply());
        builder.put(FunctionTemplate.BuiltInMathOperator.DIVIDE.getFunctionName(), new Divide());
        builder.put(FunctionTemplate.BuiltInMathOperator.MODULUS.getFunctionName(), new Modulus());
        builder.put(FunctionTemplate.BuiltInBooleanOperator.EQUALS.getFunctionName(), new Equals());
        builder.put(FunctionTemplate.BuiltInBooleanOperator.NOT_EQUALS.getFunctionName(), new NotEquals());
        builder.put(FunctionTemplate.BuiltInBooleanOperator.GREATER_THAN.getFunctionName(), new GreaterThan());
        builder.put(FunctionTemplate.BuiltInBooleanOperator.LESS_THAN.getFunctionName(), new LessThan());
        builder.put(FunctionTemplate.BuiltInBooleanOperator.GREATER_THAN_OR_EQUALS.getFunctionName(), new GreaterThanOrEquals());
        builder.put(FunctionTemplate.BuiltInBooleanOperator.LESS_THAN_OR_EQUALS.getFunctionName(), new LessThanOrEquals());
        builder.put(FunctionTemplate.BuiltInBooleanOperator.IS_TYPE.getFunctionName(), new IsType());
        builder.put(FunctionTemplate.BuiltInUnaryOperator.BOOLEAN_NOT.getFunctionName(), new BooleanNot());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.TO_INT.getFunctionName(), new ToInt());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.TO_FLOAT.getFunctionName(), new ToFloat());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.TO_STRING.getFunctionName(), new ToString());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.PATH.getFunctionName(), new Path());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.DURATION_VALUE.getFunctionName(), new DurationValue());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.DURATION_TIME.getFunctionName(), new DurationTime());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.LATLNG_VALUE.getFunctionName(), new LatLngValue());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.TIMESTAMP_VALUE.getFunctionName(), new TimestampEpoch());
        builder.put(FunctionTemplate.BuiltInTypeConversionFunction.TIMESTAMP_DATE.getFunctionName(), new TimestampDate());
        builder.put(FunctionTemplate.IS_NAN.getFunctionName(), new IsNaN());
        builder.put(FunctionTemplate.IS_INFINITY.getFunctionName(), new IsInfinity());
        builder.put(FunctionTemplate.FLOOR.getFunctionName(), new Floor());
        builder.put(FunctionTemplate.CEIL.getFunctionName(), new Ceil());
        builder.put(FunctionTemplate.ROUND.getFunctionName(), new Round());
        builder.put(FunctionTemplate.ABS.getFunctionName(), new Abs());
        builder.put(FunctionTemplate.DURATION_ABS.getFunctionName(), new DurationAbs());
        builder.put(FunctionTemplate.SHA256.getFunctionName(), new HashingFunction(FunctionTemplate.SHA256, Hashing.sha256()));
        builder.put(FunctionTemplate.CRC32.getFunctionName(), new HashingFunction(FunctionTemplate.CRC32, Hashing.crc32()));
        builder.put(FunctionTemplate.CRC32C.getFunctionName(), new HashingFunction(FunctionTemplate.CRC32C, Hashing.crc32c()));
        builder.put(FunctionTemplate.MD5.getFunctionName(), new HashingFunction(FunctionTemplate.MD5, MD5_HASH));
        this.functionMap = builder.build();
    }

    @Override
    @Nullable
    public BaseFunction getFunction(@Nullable ExpressionValue.KindCase operandType, String functionName) {
        return operandType == null ? this.functionMap.get(functionName) : null;
    }
}

