/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.common.hash.HashFunction;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.protobuf.ByteString;

public class HashingFunction
extends OverloadedRuntimeFunction {
    public HashingFunction(FunctionTemplate functionTemplate, HashFunction hash) {
        super(functionTemplate, new HashBytes(hash), new HashString(hash));
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class HashString
    implements RuntimeFunction {
        private final HashFunction hash;

        HashString(HashFunction hash) {
            this.hash = hash;
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ByteString byteString = ByteString.copyFromUtf8(request.getArguments(0).getStringValue());
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)ByteString.copyFrom(this.hash.hashBytes(byteString.toByteArray()).asBytes())));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.BYTES})
    private static class HashBytes
    implements RuntimeFunction {
        private final HashFunction hash;

        HashBytes(HashFunction hash) {
            this.hash = hash;
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ByteString bytesString = request.getArguments(0).getBytesValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)ByteString.copyFrom(this.hash.hashBytes(bytesString.toByteArray()).asBytes())));
        }
    }
}

