/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.functions.GreaterThanOrEquals;
import com.google.firebase.rules.runtime.utils.ConstraintValueUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;

public final class LessThanOrEquals
extends OverloadedRuntimeFunction {
    public LessThanOrEquals() {
        super((FunctionTemplate)FunctionTemplate.BuiltInBooleanOperator.LESS_THAN_OR_EQUALS, new LessThanOrEqualsString(), new LessThanOrEqualsBytes(), new LessThanOrEqualsInteger(), new LessThanOrEqualsFloat(), new LessThanOrEqualsDuration(), new LessThanOrEqualsTimestamp(), new LessThanOrEqualsConstraintAny(), new LessThanOrEqualsAnyConstraint(new GreaterThanOrEquals.GreaterThanOrEqualsConstraintAny()));
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY, FunctionExpects.ExpectedExpressionKind.CONSTRAINT})
    private static class LessThanOrEqualsAnyConstraint
    implements RuntimeFunction {
        private final GreaterThanOrEquals.GreaterThanOrEqualsConstraintAny greaterThanOrEqualsConstraintAny;

        public LessThanOrEqualsAnyConstraint(GreaterThanOrEquals.GreaterThanOrEqualsConstraintAny greaterThanOrEqualsConstraintAny) {
            this.greaterThanOrEqualsConstraintAny = greaterThanOrEqualsConstraintAny;
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return this.greaterThanOrEqualsConstraintAny.execute(ExpressionValueUtils.swapArguments(request));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.CONSTRAINT, FunctionExpects.ExpectedExpressionKind.ANY})
    static class LessThanOrEqualsConstraintAny
    implements RuntimeFunction {
        LessThanOrEqualsConstraintAny() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ConstraintValue leftValue = request.getArguments(0).getConstraintValue();
            ExpressionValue rightValue = request.getArguments(1);
            SimpleConstraint simpleConstraint = ExpressionValueUtils.makeSimpleConstraint(SimpleConstraint.Comparator.LTE, rightValue, request.getSourcePosition());
            if (ExpressionValueUtils.isConstraint(rightValue)) {
                throw EvaluationException.makeTypeError(request.getSourcePosition(), ExpressionValue.KindCase.CONSTRAINT_VALUE, KindCaseHelper.ORDERABLE_KIND_CASES);
            }
            return ExpressionValueUtils.createResponse(ConstraintValueUtils.implies(leftValue, simpleConstraint));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.TIMESTAMP, FunctionExpects.ExpectedExpressionKind.TIMESTAMP})
    private static class LessThanOrEqualsTimestamp
    extends LessThanOrEqualsObject {
        private LessThanOrEqualsTimestamp() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.DURATION, FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class LessThanOrEqualsDuration
    extends LessThanOrEqualsObject {
        private LessThanOrEqualsDuration() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class LessThanOrEqualsFloat
    extends LessThanOrEqualsObject {
        private LessThanOrEqualsFloat() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class LessThanOrEqualsInteger
    extends LessThanOrEqualsObject {
        private LessThanOrEqualsInteger() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.BYTES, FunctionExpects.ExpectedExpressionKind.BYTES})
    private static class LessThanOrEqualsBytes
    extends LessThanOrEqualsObject {
        private LessThanOrEqualsBytes() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING, FunctionExpects.ExpectedExpressionKind.STRING})
    private static class LessThanOrEqualsString
    extends LessThanOrEqualsObject {
        private LessThanOrEqualsString() {
        }
    }

    private static class LessThanOrEqualsObject
    implements RuntimeFunction {
        private LessThanOrEqualsObject() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue leftValue = request.getArguments(0);
            ExpressionValue rightValue = request.getArguments(1);
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(ExpressionValueUtils.lessThanOrEquals(leftValue, rightValue)));
        }
    }
}

