/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.units.DurationUtil;

public final class Negate
extends OverloadedRuntimeFunction {
    public Negate() {
        super((FunctionTemplate)FunctionTemplate.BuiltInUnaryOperator.NEGATE_NUMBER, new NegateInt(), new NegateFloat(), new NegateDuration());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.DURATION})
    private static class NegateDuration
    implements RuntimeFunction {
        private NegateDuration() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)DurationUtil.negate(request.getArguments(0).getDurationValue())));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class NegateFloat
    implements RuntimeFunction {
        private NegateFloat() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            double value = request.getArguments(0).getFloatValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(-value));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class NegateInt
    implements RuntimeFunction {
        private NegateInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            long value = request.getArguments(0).getIntValue();
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(Math.negateExact(value)));
            }
            catch (ArithmeticException e) {
                throw EvaluationException.makeIntegerOverflowError(request.getSourcePosition());
            }
        }
    }
}

