/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.KindCaseHelper;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ConstraintValueUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ConstraintValue;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.firebase.rules.runtime.v1.SimpleConstraint;

@FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY, FunctionExpects.ExpectedExpressionKind.ANY})
public final class NotEquals
extends OverloadedRuntimeFunction {
    public NotEquals() {
        super((FunctionTemplate)FunctionTemplate.BuiltInBooleanOperator.NOT_EQUALS, new NotEqualsInteger(), new NotEqualsFloat(), new NotEqualsAny());
    }

    private static ExecutionResponse constraintNotEqualsCheck(ExecutionRequest request, ConstraintValue constraintValue, ExpressionValue expressionValue) throws EvaluationException {
        SimpleConstraint rightConstraint = ExpressionValueUtils.makeSimpleConstraint(SimpleConstraint.Comparator.NEQ, expressionValue, request.getSourcePosition());
        return ExpressionValueUtils.createResponse(ConstraintValueUtils.implies(constraintValue, rightConstraint));
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY, FunctionExpects.ExpectedExpressionKind.ANY})
    private static class NotEqualsAny
    extends NotEqualsObject {
        private NotEqualsAny() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT, FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class NotEqualsFloat
    extends NotEqualsObject {
        private NotEqualsFloat() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class NotEqualsInteger
    extends NotEqualsObject {
        private NotEqualsInteger() {
        }
    }

    private static class NotEqualsObject
    implements RuntimeFunction {
        private NotEqualsObject() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue leftValue = request.getArguments(0);
            ExpressionValue rightValue = request.getArguments(1);
            if (ExpressionValueUtils.isConstraint(leftValue) && ExpressionValueUtils.isConstraint(rightValue)) {
                throw EvaluationException.makeTypeError(request.getSourcePosition(), ExpressionValue.KindCase.CONSTRAINT_VALUE, KindCaseHelper.COMPARABLE_KIND_CASES);
            }
            if (ExpressionValueUtils.isConstraint(leftValue)) {
                return NotEquals.constraintNotEqualsCheck(request, leftValue.getConstraintValue(), rightValue);
            }
            if (ExpressionValueUtils.isConstraint(rightValue)) {
                return NotEquals.constraintNotEqualsCheck(request, rightValue.getConstraintValue(), leftValue);
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(!ExpressionValueUtils.equal(leftValue, rightValue)));
        }
    }
}

