/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.lang.common.UrlEncoder;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionPathSegmentValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValue;
import com.google.firebase.rules.runtime.v1.ExpressionPathValueOrBuilder;
import com.google.firebase.rules.v1.SourcePosition;
import java.util.HashSet;
import java.util.Set;

@FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
public class Path
extends GuardedRuntimeFunction {
    private static final Splitter SLASH_SPLITTER = Splitter.on("/").trimResults();
    private static final String TEMPLATE_CAPTURE_START = "{";
    private static final String GLOB_CAPTURE_END = "=**}";
    private static final String CAPTURE_END = "=*}";
    private static final String SIMPLE_CAPTURE_END = "}";

    public Path() {
        super(FunctionTemplate.BuiltInTypeConversionFunction.PATH);
    }

    @Override
    public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
        String pathTemplate = request.getArguments(0).getStringValue();
        String path = pathTemplate;
        if (path.isEmpty()) {
            throw EvaluationException.makeEmptyPathError(request.getSourcePosition());
        }
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        ExpressionPathValue.Builder value = ExpressionPathValue.newBuilder();
        for (String segment : SLASH_SPLITTER.split(path)) {
            try {
                value.addSegments(this.makePathSegment(pathTemplate, request.getSourcePosition(), segment));
            }
            catch (UrlEncoder.UrlDecodingException e) {
                throw EvaluationException.makeUrlDecodeError(request.getSourcePosition(), segment, e.getMessage());
            }
        }
        Path.validatePath(request.getSourcePosition(), value);
        return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(value.build()));
    }

    private ExpressionPathSegmentValue.Builder makePathSegment(String pathTemplate, SourcePosition sourcePosition, String segment) throws UrlEncoder.UrlDecodingException, EvaluationException {
        String identifier;
        if (segment.isEmpty()) {
            throw EvaluationException.makeEmptyPathSegmentError(sourcePosition, pathTemplate);
        }
        if (!segment.startsWith(TEMPLATE_CAPTURE_START)) {
            return ExpressionPathSegmentValue.newBuilder().setSimple(UrlEncoder.decode(segment));
        }
        boolean glob = false;
        if (segment.endsWith(CAPTURE_END)) {
            identifier = segment.substring(TEMPLATE_CAPTURE_START.length(), segment.length() - CAPTURE_END.length()).trim();
        } else if (segment.endsWith(GLOB_CAPTURE_END)) {
            identifier = segment.substring(TEMPLATE_CAPTURE_START.length(), segment.length() - GLOB_CAPTURE_END.length()).trim();
            glob = true;
        } else if (segment.endsWith(SIMPLE_CAPTURE_END)) {
            identifier = segment.substring(TEMPLATE_CAPTURE_START.length(), segment.length() - SIMPLE_CAPTURE_END.length()).trim();
        } else {
            throw EvaluationException.makeUnclosedCaptureError(sourcePosition, pathTemplate);
        }
        if (!this.isValidIdentifier(identifier)) {
            throw EvaluationException.makeInvalidIdentifierError(sourcePosition, pathTemplate, identifier);
        }
        if (glob) {
            return ExpressionPathSegmentValue.newBuilder().setGlobCapture(ExpressionPathSegmentValue.GlobCapture.newBuilder().setVariableName(identifier));
        }
        return ExpressionPathSegmentValue.newBuilder().setCapture(ExpressionPathSegmentValue.Capture.newBuilder().setVariableName(identifier));
    }

    private boolean isValidIdentifier(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return false;
        }
        for (int i = 0; i < charSequence.length(); ++i) {
            char ch = charSequence.charAt(i);
            if (i == 0 && ch >= '0' && ch <= '9') {
                return false;
            }
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '$') continue;
            return false;
        }
        return true;
    }

    public static void validatePath(SourcePosition sourcePosition, ExpressionPathValueOrBuilder value) throws EvaluationException {
        HashSet<String> captures = Sets.newHashSet();
        for (ExpressionPathSegmentValue segment : value.getSegmentsList()) {
            switch (segment.getKindCase()) {
                case CAPTURE: {
                    Path.ensureUnique(sourcePosition, captures, segment.getCapture().getVariableName());
                    break;
                }
                case GLOB_CAPTURE: {
                    Path.ensureUnique(sourcePosition, captures, segment.getGlobCapture().getVariableName());
                    break;
                }
                case SIMPLE: {
                    break;
                }
                case KIND_NOT_SET: {
                    String string = String.valueOf(segment.getKindCase());
                    throw new RuntimeException(new StringBuilder(21 + String.valueOf(string).length()).append("Invalid path segment ").append(string).toString());
                }
            }
        }
    }

    private static void ensureUnique(SourcePosition sourcePosition, Set<String> captures, String captureName) throws EvaluationException {
        if (captures.contains(captureName)) {
            throw EvaluationException.makeBindRedefinitionError(sourcePosition, captureName);
        }
        captures.add(captureName);
    }
}

