/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public final class ToFloat
extends OverloadedRuntimeFunction {
    public ToFloat() {
        super((FunctionTemplate)FunctionTemplate.BuiltInTypeConversionFunction.TO_FLOAT, new IntToFloat(), new FloatToFloat(), new StringToFloat());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class StringToFloat
    implements RuntimeFunction {
        private StringToFloat() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue arg = request.getArguments(0);
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(Double.parseDouble(arg.getStringValue())));
            }
            catch (NumberFormatException e) {
                throw EvaluationException.makeTypeConversionError(request.getSourcePosition(), ExpressionValue.KindCase.STRING_VALUE, ExpressionValue.KindCase.FLOAT_VALUE, arg.getStringValue());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class FloatToFloat
    implements RuntimeFunction {
        private FloatToFloat() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(request.getArguments(0));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class IntToFloat
    implements RuntimeFunction {
        private IntToFloat() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((double)request.getArguments(0).getIntValue()));
        }
    }
}

