/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.functions;

import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public final class ToInt
extends OverloadedRuntimeFunction {
    public ToInt() {
        super((FunctionTemplate)FunctionTemplate.BuiltInTypeConversionFunction.TO_INT, new IntToInt(), new FloatToInt(), new StringToInt());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class StringToInt
    implements RuntimeFunction {
        private StringToInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue arg = request.getArguments(0);
            try {
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(Long.parseLong(arg.getStringValue())));
            }
            catch (NumberFormatException e) {
                throw EvaluationException.makeTypeConversionError(request.getSourcePosition(), ExpressionValue.KindCase.STRING_VALUE, ExpressionValue.KindCase.INT_VALUE, arg.getStringValue());
            }
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.FLOAT})
    private static class FloatToInt
    implements RuntimeFunction {
        private FloatToInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((long)request.getArguments(0).getFloatValue()));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class IntToInt
    implements RuntimeFunction {
        private IntToInt() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(request.getArguments(0));
        }
    }
}

