/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public class BytesType
extends AbstractTypeProvider {
    public BytesType() {
        super(ExpressionValue.KindCase.BYTES_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.BytesMembers.SIZE.getFunctionName(), new BytesSize());
        builder.put(FunctionTemplate.BytesMembers.HEX_STRING.getFunctionName(), new HexString());
        builder.put(FunctionTemplate.BytesMembers.BASE_64.getFunctionName(), new Base64());
    }

    @FunctionExpects
    private static final class Base64
    extends GuardedRuntimeFunction {
        public Base64() {
            super(FunctionTemplate.BytesMembers.BASE_64, ExpressionValue.KindCase.BYTES_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)BaseEncoding.base64Url().encode(request.getOperand().getBytesValue().toByteArray())));
        }
    }

    @FunctionExpects
    private static class HexString
    extends GuardedRuntimeFunction {
        public HexString() {
            super(FunctionTemplate.BytesMembers.HEX_STRING, ExpressionValue.KindCase.BYTES_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue((Object)BaseEncoding.base16().upperCase().encode(request.getOperand().getBytesValue().toByteArray())));
        }
    }

    @FunctionExpects
    private static class BytesSize
    extends GuardedRuntimeFunction {
        public BytesSize() {
            super(FunctionTemplate.BytesMembers.SIZE, ExpressionValue.KindCase.BYTES_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getBytesValue().size()));
        }
    }
}

