/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public class DurationType
extends AbstractTypeProvider {
    public DurationType() {
        super(ExpressionValue.KindCase.DURATION_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.DurationMembers.NANOS.getFunctionName(), new Nanos());
        builder.put(FunctionTemplate.DurationMembers.SECONDS.getFunctionName(), new Seconds());
    }

    @FunctionExpects
    public static class Seconds
    extends GuardedRuntimeFunction {
        public Seconds() {
            super(FunctionTemplate.DurationMembers.SECONDS, ExpressionValue.KindCase.DURATION_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getDurationValue().getSeconds()));
        }
    }

    @FunctionExpects
    public static class Nanos
    extends GuardedRuntimeFunction {
        public Nanos() {
            super(FunctionTemplate.DurationMembers.NANOS, ExpressionValue.KindCase.DURATION_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getDurationValue().getNanos()));
        }
    }
}

