/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import com.google.type.LatLng;

public class LatLngType
extends AbstractTypeProvider {
    public LatLngType() {
        super(ExpressionValue.KindCase.LATLNG_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.LatLngMembers.LATITUDE.getFunctionName(), new Latitude());
        builder.put(FunctionTemplate.LatLngMembers.LONGITUDE.getFunctionName(), new Longitude());
        builder.put(FunctionTemplate.LatLngMembers.DISTANCE.getFunctionName(), new Distance());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.LATLNG})
    public static class Distance
    extends GuardedRuntimeFunction {
        static final float EARTH_RADIUS = 6371009.0f;

        public Distance() {
            super(FunctionTemplate.LatLngMembers.DISTANCE, ExpressionValue.KindCase.LATLNG_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            LatLng latLng = request.getArguments(0).getLatlngValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(Distance.computeDistanceBetween(request.getOperand().getLatlngValue(), latLng)));
        }

        private static double computeDistanceBetween(LatLng from, LatLng to) {
            double lat1 = Distance.toRadians(from.getLatitude());
            double lng1 = Distance.toRadians(from.getLongitude());
            double lat2 = Distance.toRadians(to.getLatitude());
            double lng2 = Distance.toRadians(to.getLongitude());
            double havDistance = Distance.hav(lat1 - lat2) + Distance.hav(lng1 - lng2) * Math.cos(lat1) * Math.cos(lat2);
            double angleBetween = 2.0 * Math.asin(Math.sqrt(havDistance));
            return angleBetween * 6371009.0;
        }

        private static double toRadians(double deg) {
            return Math.toRadians(deg);
        }

        private static double hav(double x) {
            double sinHalf = Math.sin(x * 0.5);
            return sinHalf * sinHalf;
        }
    }

    @FunctionExpects
    private static class Longitude
    extends GuardedRuntimeFunction {
        public Longitude() {
            super(FunctionTemplate.LatLngMembers.LONGITUDE, ExpressionValue.KindCase.LATLNG_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getLatlngValue().getLongitude()));
        }
    }

    @FunctionExpects
    private static class Latitude
    extends GuardedRuntimeFunction {
        public Latitude() {
            super(FunctionTemplate.LatLngMembers.LATITUDE, ExpressionValue.KindCase.LATLNG_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getLatlngValue().getLatitude()));
        }
    }
}

