/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.impl.functions.ToString;
import com.google.firebase.rules.runtime.impl.types.RangeCheckUtils;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.ArrayList;
import java.util.List;

public class ListType
extends AbstractTypeProvider {
    public ListType() {
        super(ExpressionValue.KindCase.LIST_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.ListMembers.SIZE.getFunctionName(), new ListSize());
        builder.put(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), new ListItemAtIndex());
        builder.put(FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE.getFunctionName(), new ListLookupRange());
        builder.put(FunctionTemplate.IN.getFunctionName(), new In());
        builder.put(FunctionTemplate.ListMembers.HAS_ALL.getFunctionName(), new HasAll());
        builder.put(FunctionTemplate.ListMembers.HAS_ANY.getFunctionName(), new HasAny());
        builder.put(FunctionTemplate.ListMembers.HAS_ONLY.getFunctionName(), new HasOnly());
        builder.put(FunctionTemplate.ListMembers.JOIN.getFunctionName(), new Join());
        builder.put(FunctionTemplate.ListMembers.CONCAT.getFunctionName(), new ListConcat());
        builder.put(FunctionTemplate.ListMembers.REMOVE_ALL.getFunctionName(), new RemoveAll());
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.LIST})
    private static class RemoveAll
    extends GuardedRuntimeFunction {
        public RemoveAll() {
            super(FunctionTemplate.ListMembers.REMOVE_ALL, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            List<ExpressionValue> argument = request.getArguments(0).getListValue().getValuesList();
            List<ExpressionValue> operand = request.getOperand().getListValue().getValuesList();
            ImmutableList.Builder scrubbed = ImmutableList.builder();
            for (ExpressionValue a : operand) {
                boolean foundMatch = false;
                for (ExpressionValue b : argument) {
                    if (!ExpressionValueUtils.equal(a, b)) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                scrubbed.add(a);
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(scrubbed.build()));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.LIST})
    private static class ListConcat
    extends GuardedRuntimeFunction {
        public ListConcat() {
            super(FunctionTemplate.ListMembers.CONCAT, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionListValue argument = request.getArguments(0).getListValue();
            ExpressionListValue operand = request.getOperand().getListValue();
            ImmutableCollection both = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(operand.getValuesList())).addAll(argument.getValuesList())).build();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(both));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class Join
    extends GuardedRuntimeFunction {
        private final ToString toString = new ToString();

        public Join() {
            super(FunctionTemplate.ListMembers.JOIN, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String separator = request.getArguments(0).getStringValue();
            ArrayList<String> parts = Lists.newArrayList();
            ExpressionListValue operand = request.getOperand().getListValue();
            for (ExpressionValue operandItem : operand.getValuesList()) {
                if (ExpressionValueUtils.isUndefined(operandItem)) {
                    throw ExpressionValueUtils.propagateUndefined(operandItem);
                }
                ExecutionRequest executionRequest = ExecutionRequest.newBuilder().addAllArguments(Lists.newArrayList(operandItem)).setSourcePosition(request.getSourcePosition()).build();
                ExecutionResponse result = this.toString.execute(executionRequest);
                parts.add(result.getValue().getStringValue());
            }
            ExpressionValue result = ExpressionValue.newBuilder().setStringValue(Joiner.on(separator).join(parts)).build();
            return ExpressionValueUtils.createResponse(result);
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.LIST})
    private static class HasOnly
    extends GuardedRuntimeFunction {
        public HasOnly() {
            super(FunctionTemplate.ListMembers.HAS_ONLY, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionListValue argument = request.getArguments(0).getListValue();
            ExpressionListValue operand = request.getOperand().getListValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(HasOnly.hasOnly(operand, argument)));
        }

        private static boolean hasOnly(ExpressionListValue a, ExpressionListValue b) throws EvaluationException {
            for (ExpressionValue aItem : a.getValuesList()) {
                boolean foundMatch = false;
                for (ExpressionValue bItem : b.getValuesList()) {
                    if (!ExpressionValueUtils.equal(aItem, bItem)) continue;
                    foundMatch = true;
                    break;
                }
                if (foundMatch) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.LIST})
    private static class HasAny
    extends GuardedRuntimeFunction {
        public HasAny() {
            super(FunctionTemplate.ListMembers.HAS_ANY, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionListValue argument = request.getArguments(0).getListValue();
            ExpressionListValue operand = request.getOperand().getListValue();
            for (ExpressionValue argumentItem : argument.getValuesList()) {
                for (ExpressionValue operandItem : operand.getValuesList()) {
                    if (!ExpressionValueUtils.equal(argumentItem, operandItem)) continue;
                    return ExpressionValueUtils.createResponse(ExpressionValueUtils.TRUE);
                }
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.FALSE);
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.LIST})
    private static class HasAll
    extends GuardedRuntimeFunction {
        public HasAll() {
            super(FunctionTemplate.ListMembers.HAS_ALL, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionListValue argument = request.getArguments(0).getListValue();
            ExpressionListValue operand = request.getOperand().getListValue();
            for (ExpressionValue argumentItem : argument.getValuesList()) {
                boolean hasElement = false;
                for (ExpressionValue operandItem : operand.getValuesList()) {
                    if (!ExpressionValueUtils.equal(argumentItem, operandItem)) continue;
                    hasElement = true;
                    break;
                }
                if (hasElement) continue;
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.FALSE);
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.TRUE);
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.ANY})
    private static class In
    extends GuardedRuntimeFunction {
        public In() {
            super(FunctionTemplate.IN, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionValue argument = request.getArguments(0);
            ExpressionListValue operand = request.getOperand().getListValue();
            for (ExpressionValue listItem : operand.getValuesList()) {
                if (!ExpressionValueUtils.equal(listItem, argument)) continue;
                return ExpressionValueUtils.createResponse(ExpressionValueUtils.TRUE);
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.FALSE);
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.INT})
    private static class ListRangeIntInt
    extends ListRange {
        private ListRangeIntInt() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT, FunctionExpects.ExpectedExpressionKind.NULL})
    private static class ListRangeIntNull
    extends ListRange {
        private ListRangeIntNull() {
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.NULL, FunctionExpects.ExpectedExpressionKind.INT})
    private static class ListRangeNullInt
    extends ListRange {
        private ListRangeNullInt() {
        }
    }

    private static abstract class ListRange
    implements RuntimeFunction {
        private ListRange() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            List<ExpressionValue> valuesList = request.getOperand().getListValue().getValuesList();
            int listLength = valuesList.size();
            ExpressionValue rangeStart = request.getArguments(0);
            ExpressionValue rangeEnd = request.getArguments(1);
            int fromIndex = RangeCheckUtils.getFromIndex(request, rangeStart, listLength);
            int toIndex = RangeCheckUtils.getToIndex(request, rangeEnd, listLength);
            RangeCheckUtils.checkRange(request, fromIndex, listLength);
            RangeCheckUtils.checkRange(request, toIndex - 1, listLength);
            if (toIndex < fromIndex) {
                throw EvaluationException.makeIllegalRangeError(request.getSourcePosition(), fromIndex, toIndex);
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(valuesList.subList(fromIndex, toIndex)));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.NULL, FunctionExpects.ExpectedExpressionKind.NULL})
    private static class ListReference
    implements RuntimeFunction {
        private ListReference() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(request.getOperand());
        }
    }

    private static class ListLookupRange
    extends OverloadedRuntimeFunction {
        public ListLookupRange() {
            super((FunctionTemplate)FunctionTemplate.BuiltInRangeFunction.LOOKUP_RANGE, ExpressionValue.KindCase.LIST_VALUE, new ListReference(), new ListRangeNullInt(), new ListRangeIntNull(), new ListRangeIntInt());
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.INT})
    private static class ListItemAtIndex
    extends GuardedRuntimeFunction {
        public ListItemAtIndex() {
            super(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            int index;
            List<ExpressionValue> valuesList = request.getOperand().getListValue().getValuesList();
            ExpressionValue indexArg = request.getArguments(0);
            try {
                index = Math.toIntExact(indexArg.getIntValue());
            }
            catch (ArithmeticException e) {
                throw EvaluationException.makeIndexOutOfBoundError(request.getSourcePosition(), indexArg.getIntValue(), valuesList.size());
            }
            RangeCheckUtils.checkRange(request, index, valuesList.size());
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(valuesList.get(index)));
        }
    }

    @FunctionExpects
    public static class ListSize
    extends GuardedRuntimeFunction {
        public ListSize() {
            super(FunctionTemplate.ListMembers.SIZE, ExpressionValue.KindCase.LIST_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(request.getOperand().getListValue().getValuesCount()));
        }
    }
}

