/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.rules.lang.common.FunctionTemplate;
import com.google.firebase.rules.runtime.common.AbstractTypeProvider;
import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.common.RuntimeFunction;
import com.google.firebase.rules.runtime.common.UnicodeComparator;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.utils.FunctionExpects;
import com.google.firebase.rules.runtime.utils.GuardedRuntimeFunction;
import com.google.firebase.rules.runtime.utils.OverloadedRuntimeFunction;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExecutionResponse;
import com.google.firebase.rules.runtime.v1.ExpressionListValue;
import com.google.firebase.rules.runtime.v1.ExpressionMapValue;
import com.google.firebase.rules.runtime.v1.ExpressionValue;
import java.util.List;
import java.util.Map;

public class MapType
extends AbstractTypeProvider {
    public MapType() {
        super(ExpressionValue.KindCase.MAP_VALUE);
    }

    @Override
    protected void register(ImmutableMap.Builder<String, RuntimeFunction> builder) {
        builder.put(FunctionTemplate.MapMembers.SIZE.getFunctionName(), new MapSize());
        builder.put(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX.getFunctionName(), new MapItemAtIndex());
        builder.put(FunctionTemplate.MapMembers.GET_OR_DEFAULT.getFunctionName(), new GetOrDefault());
        builder.put(FunctionTemplate.IN.getFunctionName(), new In());
        builder.put(FunctionTemplate.MapMembers.KEYS.getFunctionName(), new MapKeys());
        builder.put(FunctionTemplate.MapMembers.VALUES.getFunctionName(), new MapValues());
    }

    @FunctionExpects
    public static class MapValues
    extends GuardedRuntimeFunction {
        public MapValues() {
            super(FunctionTemplate.MapMembers.VALUES, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionListValue.Builder result = ExpressionListValue.newBuilder();
            ExpressionMapValue mapValue = request.getOperand().getMapValue();
            for (Map.Entry<String, ExpressionValue> entry : mapValue.getFieldsMap().entrySet()) {
                result.addValues(entry.getValue());
            }
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(result.build()));
        }
    }

    @FunctionExpects
    public static class MapKeys
    extends GuardedRuntimeFunction {
        public MapKeys() {
            super(FunctionTemplate.MapMembers.KEYS, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ImmutableList<String> keys = ImmutableList.sortedCopyOf(UnicodeComparator.INSTANCE, request.getOperand().getMapValue().getFieldsMap().keySet());
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(keys));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    private static class In
    extends GuardedRuntimeFunction {
        public In() {
            super(FunctionTemplate.IN, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String key = request.getArguments(0).getStringValue();
            Map<String, ExpressionValue> map = request.getOperand().getMapValue().getFieldsMap();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(map.containsKey(key)));
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.LIST, FunctionExpects.ExpectedExpressionKind.ANY})
    private static class GetListOrDefault
    implements RuntimeFunction {
        private GetListOrDefault() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            List<ExpressionValue> keyList = request.getArguments(0).getListValue().getValuesList();
            for (ExpressionValue key : keyList) {
                if (key.getKindCase().equals(ExpressionValue.KindCase.STRING_VALUE)) continue;
                throw EvaluationException.makeTypeError(request.getSourcePosition(), key.getKindCase(), ExpressionValue.KindCase.STRING_VALUE);
            }
            ExpressionValue defaultValue = request.getArguments(1);
            ExpressionValue result = request.getOperand();
            for (ExpressionValue key : keyList) {
                if ((result = result.getMapValue().getFieldsMap().get(key.getStringValue())) != null) continue;
                return ExpressionValueUtils.createResponse(defaultValue);
            }
            return ExpressionValueUtils.createResponse(result);
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING, FunctionExpects.ExpectedExpressionKind.ANY})
    private static class GetSingleOrDefault
    implements RuntimeFunction {
        private GetSingleOrDefault() {
        }

        @Override
        public ExecutionResponse execute(ExecutionRequest request) throws EvaluationException {
            Map<String, ExpressionValue> map = request.getOperand().getMapValue().getFieldsMap();
            String key = request.getArguments(0).getStringValue();
            ExpressionValue defaultValue = request.getArguments(1);
            return ExpressionValueUtils.createResponse(map.getOrDefault(key, defaultValue));
        }
    }

    public static class GetOrDefault
    extends OverloadedRuntimeFunction {
        public GetOrDefault() {
            super(FunctionTemplate.MapMembers.GET_OR_DEFAULT, ExpressionValue.KindCase.MAP_VALUE, new GetSingleOrDefault(), new GetListOrDefault());
        }
    }

    @FunctionExpects(arguments={FunctionExpects.ExpectedExpressionKind.STRING})
    public static class MapItemAtIndex
    extends GuardedRuntimeFunction {
        public MapItemAtIndex() {
            super(FunctionTemplate.BuiltInIndexFunction.LOOKUP_INDEX, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            String key = request.getArguments(0).getStringValue();
            Map<String, ExpressionValue> values = request.getOperand().getMapValue().getFieldsMap();
            if (values.containsKey(key)) {
                return ExpressionValueUtils.createResponse(values.get(key));
            }
            throw EvaluationException.makeUndefinedPropertyError(request.getSourcePosition(), key);
        }
    }

    @FunctionExpects
    public static class MapSize
    extends GuardedRuntimeFunction {
        public MapSize() {
            super(FunctionTemplate.MapMembers.SIZE, ExpressionValue.KindCase.MAP_VALUE);
        }

        @Override
        public ExecutionResponse doExecute(ExecutionRequest request) throws EvaluationException {
            ExpressionMapValue mapValue = request.getOperand().getMapValue();
            return ExpressionValueUtils.createResponse(ExpressionValueUtils.createValue(mapValue.getFieldsMap().size()));
        }
    }
}

