/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.rules.runtime.impl.types;

import com.google.firebase.rules.runtime.common.EvaluationException;
import com.google.firebase.rules.runtime.utils.ExpressionValueUtils;
import com.google.firebase.rules.runtime.v1.ExecutionRequest;
import com.google.firebase.rules.runtime.v1.ExpressionValue;

public class RangeCheckUtils {
    private RangeCheckUtils() {
    }

    static int getFromIndex(ExecutionRequest request, ExpressionValue fromValue, int size) throws EvaluationException {
        if (ExpressionValueUtils.isNull(fromValue)) {
            return 0;
        }
        try {
            return Math.toIntExact(fromValue.getIntValue());
        }
        catch (ArithmeticException e) {
            throw EvaluationException.makeIndexOutOfBoundError(request.getSourcePosition(), fromValue.getIntValue(), size);
        }
    }

    static int getToIndex(ExecutionRequest request, ExpressionValue toValue, int size) throws EvaluationException {
        if (ExpressionValueUtils.isNull(toValue)) {
            return size;
        }
        try {
            return Math.toIntExact(toValue.getIntValue());
        }
        catch (ArithmeticException e) {
            throw EvaluationException.makeIndexOutOfBoundError(request.getSourcePosition(), toValue.getIntValue(), size);
        }
    }

    static void checkRange(ExecutionRequest request, int index, int size) throws EvaluationException {
        if (index > size - 1 || index < 0) {
            throw EvaluationException.makeIndexOutOfBoundError(request.getSourcePosition(), index, size);
        }
    }
}

